/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import javax.transaction.TransactionManager;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@DefaultFactoryFor(classes={TransactionManager.class})
public class TransactionManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    private static final Log log = LogFactory.getLog(TransactionManagerFactory.class);

    @Override
    public Object construct(String componentName) {
        if (!this.configuration.transaction().transactionMode().isTransactional()) {
            return null;
        }
        TransactionManager transactionManager = null;
        TransactionManagerLookup lookup = this.configuration.transaction().transactionManagerLookup();
        try {
            if (lookup != null) {
                this.componentRegistry.wireDependencies(lookup);
                transactionManager = lookup.getTransactionManager();
            }
        }
        catch (Exception e) {
            log.couldNotInstantiateTransactionManager(e);
        }
        if (transactionManager == null && this.configuration.invocationBatching().enabled()) {
            log.usingBatchModeTransactionManager();
            transactionManager = BatchModeTransactionManager.getInstance();
        }
        if (transactionManager == null) {
            throw new CacheException("This is transactional cache but no transaction manager could be found. Configure the transaction manager lookup properly.");
        }
        return transactionManager;
    }
}

