/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.infinispan.CacheStream;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.metadata.Metadata;
import org.infinispan.stream.StreamMarshalling;
import org.jboss.marshalling.util.IdentityIntMap;

public final class CacheFilters {
    private CacheFilters() {
    }

    public static <K, V> Predicate<CacheEntry<K, V>> predicate(KeyValueFilter<? super K, ? super V> filter) {
        return new KeyValueFilterAsPredicate<K, V>(filter);
    }

    public static <K, V, C> Function<CacheEntry<K, V>, CacheEntry<K, C>> function(Converter<? super K, ? super V, C> converter) {
        return new ConverterAsCacheEntryFunction<K, V, C>(converter);
    }

    public static <K, V, C> Stream<CacheEntry<K, C>> filterAndConvert(Stream<CacheEntry<K, V>> stream, KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
        return stream.map(new FilterConverterAsCacheEntryFunction<K, V, C>(filterConverter)).filter(StreamMarshalling.nonNullPredicate());
    }

    public static <K, V, C> CacheStream<CacheEntry<K, C>> filterAndConvert(CacheStream<CacheEntry<K, V>> stream, KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
        return stream.map(new FilterConverterAsCacheEntryFunction<K, V, C>(filterConverter)).filter(StreamMarshalling.nonNullPredicate());
    }

    public static final class CacheFiltersExternalizer
    implements AdvancedExternalizer<Object> {
        private static final int KEY_VALUE_FILTER_PREDICATE = 0;
        private static final int CONVERTER_FUNCTION = 1;
        private static final int FILTER_CONVERTER_FUNCTION = 2;
        private final IdentityIntMap<Class<?>> objects = new IdentityIntMap();

        public CacheFiltersExternalizer() {
            this.objects.put(KeyValueFilterAsPredicate.class, 0);
            this.objects.put(ConverterAsCacheEntryFunction.class, 1);
            this.objects.put(FilterConverterAsCacheEntryFunction.class, 2);
        }

        @Override
        public Set<Class<?>> getTypeClasses() {
            return Util.asSet(KeyValueFilterAsPredicate.class, ConverterAsCacheEntryFunction.class, FilterConverterAsCacheEntryFunction.class);
        }

        @Override
        public Integer getId() {
            return 87;
        }

        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
            int number = this.objects.get(object.getClass(), -1);
            output.writeByte(number);
            switch (number) {
                case 0: {
                    output.writeObject(((KeyValueFilterAsPredicate)object).filter);
                    break;
                }
                case 1: {
                    output.writeObject(((ConverterAsCacheEntryFunction)object).converter);
                    break;
                }
                case 2: {
                    output.writeObject(((FilterConverterAsCacheEntryFunction)object).converter);
                }
            }
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int number = input.readUnsignedByte();
            switch (number) {
                case 0: {
                    return new KeyValueFilterAsPredicate((KeyValueFilter)input.readObject());
                }
                case 1: {
                    return new ConverterAsCacheEntryFunction((Converter)input.readObject());
                }
                case 2: {
                    return new FilterConverterAsCacheEntryFunction((KeyValueFilterConverter)input.readObject());
                }
            }
            throw new IllegalArgumentException("Found invalid number " + number);
        }
    }

    private static class FilterConverterAsCacheEntryFunction<K, V, C>
    implements Function<CacheEntry<K, V>, CacheEntry<K, C>> {
        protected final KeyValueFilterConverter<? super K, ? super V, C> converter;
        protected InternalEntryFactory factory;

        public FilterConverterAsCacheEntryFunction(KeyValueFilterConverter<? super K, ? super V, C> converter) {
            Objects.nonNull(converter);
            this.converter = converter;
        }

        @Inject
        public void inject(InternalEntryFactory factory, ComponentRegistry registry) {
            this.factory = factory;
            registry.wireDependencies(this.converter);
        }

        @Override
        public CacheEntry<K, C> apply(CacheEntry<K, V> kvCacheEntry) {
            Metadata metadata;
            V value;
            K key = kvCacheEntry.getKey();
            C converted = this.converter.filterAndConvert(key, value = kvCacheEntry.getValue(), metadata = kvCacheEntry.getMetadata());
            if (converted == null) {
                return null;
            }
            return this.factory.create(key, converted, metadata);
        }
    }

    private static class ConverterAsCacheEntryFunction<K, V, C>
    implements Function<CacheEntry<K, V>, CacheEntry<K, C>> {
        protected final Converter<? super K, ? super V, C> converter;
        protected InternalEntryFactory factory;

        public ConverterAsCacheEntryFunction(Converter<? super K, ? super V, C> converter) {
            Objects.nonNull(converter);
            this.converter = converter;
        }

        @Inject
        public void inject(InternalEntryFactory factory, ComponentRegistry registry) {
            this.factory = factory;
            registry.wireDependencies(this.converter);
        }

        @Override
        public CacheEntry<K, C> apply(CacheEntry<K, V> kvCacheEntry) {
            Metadata metadata;
            C converted;
            K key = kvCacheEntry.getKey();
            V value = kvCacheEntry.getValue();
            if (value == (converted = this.converter.convert(key, value, metadata = kvCacheEntry.getMetadata()))) {
                return kvCacheEntry;
            }
            return this.factory.create(key, converted, metadata);
        }
    }

    private static class KeyValueFilterAsPredicate<K, V>
    implements Predicate<CacheEntry<K, V>> {
        private final KeyValueFilter<? super K, ? super V> filter;

        public KeyValueFilterAsPredicate(KeyValueFilter<? super K, ? super V> filter) {
            Objects.nonNull(filter);
            this.filter = filter;
        }

        @Override
        public boolean test(CacheEntry<K, V> kvCacheEntry) {
            return this.filter.accept(kvCacheEntry.getKey(), kvCacheEntry.getValue(), kvCacheEntry.getMetadata());
        }

        @Inject
        public void inject(ComponentRegistry registry) {
            registry.wireDependencies(this.filter);
        }
    }
}

