/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Experimental;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.encoding.DataConversion;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.MetaParams;
import org.infinispan.functional.impl.MetaParamsInternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.Metadatas;

@Experimental
public final class EntryViews {
    private EntryViews() {
    }

    public static <K, V> EntryView.ReadEntryView<K, V> readOnly(CacheEntry<K, V> entry, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return new EntryBackedReadOnlyView(entry, keyDataConversion, valueDataConversion);
    }

    public static <K, V> EntryView.ReadEntryView<K, V> readOnly(CacheEntry entry) {
        return new EntryBackedReadOnlyView(entry, DataConversion.DEFAULT_KEY, DataConversion.DEFAULT_VALUE);
    }

    public static <K, V> EntryView.ReadEntryView<K, V> readOnly(K key, V value, Metadata metadata) {
        return new ReadOnlySnapshotView(key, value, metadata);
    }

    public static <K, V> EntryView.WriteEntryView<K, V> writeOnly(CacheEntry entry, DataConversion valueDataConversion) {
        return new EntryBackedWriteOnlyView(entry, valueDataConversion);
    }

    public static <K, V> AccessLoggingReadWriteView<K, V> readWrite(MVCCEntry entry, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return new EntryBackedReadWriteView(entry, keyDataConversion, valueDataConversion);
    }

    public static <K, V> AccessLoggingReadWriteView<K, V> readWrite(MVCCEntry entry, Object prevValue, Metadata prevMetadata, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return new EntryAndPreviousReadWriteView(entry, prevValue, prevMetadata, keyDataConversion, valueDataConversion);
    }

    public static <K, V> EntryView.ReadEntryView<K, V> noValue(Object key) {
        return new NoValueReadOnlyView(key, null);
    }

    public static <K, V> EntryView.ReadEntryView<K, V> noValue(Object key, DataConversion keyDataConversion) {
        return new NoValueReadOnlyView(key, keyDataConversion);
    }

    public static <R> R snapshot(R ret) {
        if (ret instanceof EntryBackedReadWriteView) {
            EntryBackedReadWriteView view = (EntryBackedReadWriteView)ret;
            return (R)new ReadWriteSnapshotView(view.key(), view.find().orElse(null), view.entry.getMetadata());
        }
        if (ret instanceof EntryAndPreviousReadWriteView) {
            EntryAndPreviousReadWriteView view = (EntryAndPreviousReadWriteView)ret;
            return (R)new ReadWriteSnapshotView(view.key(), view.getCurrentValue(), view.entry.getMetadata());
        }
        if (ret instanceof EntryBackedReadOnlyView) {
            EntryBackedReadOnlyView view = (EntryBackedReadOnlyView)ret;
            return (R)new ReadOnlySnapshotView(view.key(), view.find().orElse(null), view.entry.getMetadata());
        }
        if (ret instanceof NoValueReadOnlyView) {
            NoValueReadOnlyView view = (NoValueReadOnlyView)ret;
            return (R)new ReadOnlySnapshotView(view.key(), null, null);
        }
        return ret;
    }

    private static <K, V> void updateMetaParams(CacheEntry<K, V> entry, MetaParam.Writable[] metas) {
        Optional<EntryVersion> version = Optional.ofNullable(entry.getMetadata()).map(m -> m.version());
        MetaParams metaParams = MetaParams.empty();
        if (version.isPresent()) {
            metaParams.add(new MetaParam.MetaEntryVersion(version.get()));
        }
        if (metas.length != 0) {
            metaParams.addMany(metas);
        }
        Metadatas.updateMetadata(entry, MetaParamsInternalMetadata.from(metaParams));
    }

    private static <K, V> MetaParams extractMetaParams(CacheEntry<K, V> entry) {
        Metadata metadata = entry.getMetadata();
        if (metadata instanceof MetaParamsInternalMetadata) {
            MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
            return metaParamsMetadata.params;
        }
        return MetaParams.empty();
    }

    public static final class ReadWriteSnapshotViewExternalizer
    extends AbstractExternalizer<ReadWriteSnapshotView> {
        @Override
        public Integer getId() {
            return 94;
        }

        @Override
        public Set<Class<? extends ReadWriteSnapshotView>> getTypeClasses() {
            return Util.asSet(ReadWriteSnapshotView.class);
        }

        @Override
        public void writeObject(ObjectOutput output, ReadWriteSnapshotView obj) throws IOException {
            output.writeObject(obj.key);
            output.writeObject(obj.value);
            output.writeObject(obj.metadata);
        }

        @Override
        public ReadWriteSnapshotView readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object key = input.readObject();
            Object value = input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            return new ReadWriteSnapshotView<Object, Object>(key, value, metadata);
        }
    }

    public static final class NoValueReadOnlyViewExternalizer
    implements AdvancedExternalizer<NoValueReadOnlyView> {
        @Override
        public Set<Class<? extends NoValueReadOnlyView>> getTypeClasses() {
            return Util.asSet(NoValueReadOnlyView.class);
        }

        @Override
        public Integer getId() {
            return 99;
        }

        @Override
        public void writeObject(ObjectOutput output, NoValueReadOnlyView object) throws IOException {
            output.writeObject(object.key);
        }

        @Override
        public NoValueReadOnlyView readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new NoValueReadOnlyView(input.readObject(), null);
        }
    }

    public static final class ReadOnlySnapshotViewExternalizer
    implements AdvancedExternalizer<ReadOnlySnapshotView> {
        @Override
        public Set<Class<? extends ReadOnlySnapshotView>> getTypeClasses() {
            return Util.asSet(ReadOnlySnapshotView.class);
        }

        @Override
        public Integer getId() {
            return 98;
        }

        @Override
        public void writeObject(ObjectOutput output, ReadOnlySnapshotView object) throws IOException {
            output.writeObject(object.key);
            output.writeObject(object.value);
            output.writeObject(object.metadata);
        }

        @Override
        public ReadOnlySnapshotView readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object key = input.readObject();
            Object value = input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            return new ReadOnlySnapshotView(key, value, metadata);
        }
    }

    private static final class ReadWriteSnapshotView<K, V>
    implements EntryView.ReadWriteEntryView<K, V> {
        final K key;
        final V value;
        final Metadata metadata;

        public ReadWriteSnapshotView(K key, V value, Metadata metadata) {
            this.key = key;
            this.value = value;
            this.metadata = metadata;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V get() throws NoSuchElementException {
            if (this.value == null) {
                throw new NoSuchElementException("No value present");
            }
            return this.value;
        }

        @Override
        public Optional<V> find() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public <T extends MetaParam> Optional<T> findMetaParam(Class<T> type) {
            if (this.metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)this.metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            throw new IllegalStateException("A read-write entry view cannot be modified outside the scope of a lambda");
        }

        @Override
        public Void set(V value, Metadata metadata) {
            throw new IllegalStateException("A read-write entry view cannot be modified outside the scope of a lambda");
        }

        @Override
        public Void remove() {
            throw new IllegalStateException("A read-write entry view cannot be modified outside the scope of a lambda");
        }

        public String toString() {
            return "ReadWriteSnapshotView{key=" + this.key + ", value=" + this.value + ", metadata=" + this.metadata + '}';
        }
    }

    private static final class NoValueReadOnlyView<K, V>
    implements EntryView.ReadEntryView<K, V> {
        final Object key;
        private final DataConversion keyDataConversion;

        public NoValueReadOnlyView(Object key, DataConversion keyDataConversion) {
            this.key = key;
            this.keyDataConversion = keyDataConversion;
        }

        @Override
        public K key() {
            return (K)this.keyDataConversion.fromStorage(this.key);
        }

        @Override
        public V get() throws NoSuchElementException {
            throw new NoSuchElementException("No value for key " + this.key());
        }

        @Override
        public Optional<V> find() {
            return Optional.empty();
        }

        @Override
        public <T extends MetaParam> Optional<T> findMetaParam(Class<T> type) {
            return Optional.empty();
        }

        public String toString() {
            return "NoValueReadOnlyView{key=" + this.key() + '}';
        }
    }

    private static final class EntryAndPreviousReadWriteView<K, V>
    implements AccessLoggingReadWriteView<K, V> {
        final MVCCEntry entry;
        final Object prevValue;
        final Metadata prevMetadata;
        private final DataConversion keyDataConversion;
        private final DataConversion valueDataConversion;
        private K decodedKey;
        private V decodedPrevValue;
        private V decodedValue;
        private boolean isRead;

        private EntryAndPreviousReadWriteView(MVCCEntry entry, Object prevValue, Metadata prevMetadata, DataConversion keyDataConversion, DataConversion valueDataConversion) {
            this.entry = entry;
            this.prevValue = prevValue;
            this.prevMetadata = prevMetadata;
            this.keyDataConversion = keyDataConversion;
            this.valueDataConversion = valueDataConversion;
        }

        @Override
        public K key() {
            if (this.decodedKey == null) {
                this.decodedKey = this.keyDataConversion.fromStorage(this.entry.getKey());
            }
            return this.decodedKey;
        }

        @Override
        public Optional<V> find() {
            this.isRead = true;
            return this.peek();
        }

        @Override
        public Optional<V> peek() {
            if (this.decodedPrevValue == null) {
                this.decodedPrevValue = this.valueDataConversion.fromStorage(this.prevValue);
            }
            return Optional.ofNullable(this.decodedPrevValue);
        }

        public V getCurrentValue() {
            this.isRead = true;
            if (this.decodedValue == null) {
                this.decodedValue = this.valueDataConversion.fromStorage(this.entry.getValue());
            }
            return this.decodedValue;
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            this.setOnly(value, metas);
            return null;
        }

        @Override
        public Void set(V value, Metadata metadata) {
            this.setValue(value);
            Metadatas.updateMetadata(this.entry, metadata);
            return null;
        }

        private void setOnly(V value, MetaParam.Writable[] metas) {
            this.setValue(value);
            EntryViews.updateMetaParams(this.entry, metas);
        }

        private void setValue(V value) {
            this.decodedValue = value;
            Object valueEncoded = this.valueDataConversion.toStorage(value);
            this.entry.setValue(valueEncoded);
            this.entry.setChanged(true);
            this.entry.setRemoved(valueEncoded == null);
            this.entry.setCreated(this.prevValue == null && valueEncoded != null);
        }

        @Override
        public Void remove() {
            this.decodedValue = null;
            this.entry.setRemoved(this.prevValue != null);
            this.entry.setCreated(false);
            this.entry.setChanged(this.prevValue != null);
            this.entry.setValue(null);
            return null;
        }

        @Override
        public <T extends MetaParam> Optional<T> findMetaParam(Class<T> type) {
            this.isRead = true;
            if (type == MetaParam.MetaLoadedFromPersistence.class) {
                return Optional.of(MetaParam.MetaLoadedFromPersistence.of(this.entry.isLoaded()));
            }
            Metadata metadata = this.prevMetadata;
            if (metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        @Override
        public V get() throws NoSuchElementException {
            this.isRead = true;
            if (this.prevValue == null) {
                throw new NoSuchElementException();
            }
            if (this.decodedPrevValue == null) {
                this.decodedPrevValue = this.valueDataConversion.fromStorage(this.prevValue);
            }
            return this.decodedPrevValue;
        }

        public String toString() {
            return "EntryAndPreviousReadWriteView{entry=" + this.entry + ", prevValue=" + this.prevValue + ", prevMetadata=" + this.prevMetadata + '}';
        }

        @Override
        public boolean isRead() {
            return this.isRead;
        }
    }

    private static final class EntryBackedReadWriteView<K, V>
    implements AccessLoggingReadWriteView<K, V> {
        final MVCCEntry entry;
        private final DataConversion keyDataConversion;
        private final DataConversion valueDataConversion;
        private final boolean existsBefore;
        private K decodedKey;
        private V decodedValue;
        private boolean isRead;

        private EntryBackedReadWriteView(MVCCEntry entry, DataConversion keyDataConversion, DataConversion valueDataConversion) {
            this.entry = entry;
            this.keyDataConversion = keyDataConversion;
            this.valueDataConversion = valueDataConversion;
            this.existsBefore = entry.getValue() != null;
        }

        @Override
        public K key() {
            if (this.entry == null) {
                return null;
            }
            if (this.decodedKey == null) {
                this.decodedKey = this.keyDataConversion.fromStorage(this.entry.getKey());
            }
            return this.decodedKey;
        }

        @Override
        public Optional<V> find() {
            this.isRead = true;
            return this.peek();
        }

        @Override
        public Optional<V> peek() {
            if (this.entry == null) {
                return Optional.empty();
            }
            if (this.decodedValue == null) {
                this.decodedValue = this.valueDataConversion.fromStorage(this.entry.getValue());
            }
            return Optional.ofNullable(this.decodedValue);
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            this.setOnly(value, metas);
            return null;
        }

        @Override
        public Void set(V value, Metadata metadata) {
            this.setEntry(value);
            Metadatas.updateMetadata(this.entry, metadata);
            return null;
        }

        private void setOnly(V value, MetaParam.Writable[] metas) {
            this.setEntry(value);
            EntryViews.updateMetaParams(this.entry, metas);
        }

        private void setEntry(V value) {
            this.decodedValue = value;
            Object valueEncoded = this.valueDataConversion.toStorage(value);
            this.entry.setCreated(this.entry.getValue() == null && valueEncoded != null);
            this.entry.setValue(valueEncoded);
            this.entry.setChanged(true);
            this.entry.setRemoved(valueEncoded == null);
        }

        @Override
        public Void remove() {
            this.decodedValue = null;
            this.entry.setRemoved(this.existsBefore);
            this.entry.setChanged(this.existsBefore);
            this.entry.setValue(null);
            this.entry.setCreated(false);
            return null;
        }

        @Override
        public <T extends MetaParam> Optional<T> findMetaParam(Class<T> type) {
            Metadata metadata = this.entry.getMetadata();
            if (type == MetaParam.MetaLoadedFromPersistence.class) {
                return Optional.of(MetaParam.MetaLoadedFromPersistence.of(this.entry.isLoaded()));
            }
            if (metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        @Override
        public V get() throws NoSuchElementException {
            this.isRead = true;
            if (this.entry == null || this.entry.getValue() == null) {
                throw new NoSuchElementException("No value present");
            }
            this.decodedValue = this.decodedValue == null ? this.valueDataConversion.fromStorage(this.entry.getValue()) : this.decodedValue;
            return this.decodedValue;
        }

        public String toString() {
            return "EntryBackedReadWriteView{entry=" + this.entry + '}';
        }

        @Override
        public boolean isRead() {
            return this.isRead;
        }
    }

    private static final class EntryBackedWriteOnlyView<K, V>
    implements EntryView.WriteEntryView<K, V> {
        final CacheEntry entry;
        private final DataConversion valueDataConversion;

        private EntryBackedWriteOnlyView(CacheEntry entry, DataConversion valueDataConversion) {
            this.entry = entry;
            this.valueDataConversion = valueDataConversion;
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            this.setValue(value);
            EntryViews.updateMetaParams(this.entry, metas);
            return null;
        }

        @Override
        public Void set(V value, Metadata metadata) {
            this.setValue(value);
            Metadatas.updateMetadata(this.entry, metadata);
            return null;
        }

        private void setValue(V value) {
            Object encodedValue = this.valueDataConversion.toStorage(value);
            this.entry.setValue(encodedValue);
            this.entry.setChanged(true);
            this.entry.setRemoved(value == null);
        }

        @Override
        public K key() {
            return this.entry.getKey();
        }

        @Override
        public Void remove() {
            this.entry.setRemoved(true);
            this.entry.setChanged(true);
            this.entry.setValue(null);
            return null;
        }

        public String toString() {
            return "EntryBackedWriteOnlyView{entry=" + this.entry + '}';
        }
    }

    private static final class ReadOnlySnapshotView<K, V>
    implements EntryView.ReadEntryView<K, V> {
        final K key;
        final V value;
        final Metadata metadata;

        private ReadOnlySnapshotView(K key, V value, Metadata metadata) {
            this.key = key;
            this.value = value;
            this.metadata = metadata;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V get() throws NoSuchElementException {
            if (this.value == null) {
                throw new NoSuchElementException("No value");
            }
            return this.value;
        }

        @Override
        public Optional<V> find() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public <T extends MetaParam> Optional<T> findMetaParam(Class<T> type) {
            if (this.metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)this.metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        public String toString() {
            return "ReadOnlySnapshotView{key=" + this.key + ", value=" + this.value + ", metadata=" + this.metadata + '}';
        }
    }

    private static final class EntryBackedReadOnlyView<K, V>
    implements EntryView.ReadEntryView<K, V> {
        final CacheEntry<K, V> entry;
        private final DataConversion keyDataConversion;
        private final DataConversion valueDataConversion;

        private EntryBackedReadOnlyView(CacheEntry<K, V> entry, DataConversion keyDataConversion, DataConversion valueDataConversion) {
            this.entry = entry;
            this.keyDataConversion = keyDataConversion;
            this.valueDataConversion = valueDataConversion;
        }

        @Override
        public K key() {
            return (K)this.keyDataConversion.fromStorage(this.entry.getKey());
        }

        @Override
        public Optional<V> find() {
            return this.entry == null ? Optional.empty() : Optional.ofNullable(this.valueDataConversion.fromStorage(this.entry.getValue()));
        }

        @Override
        public V get() throws NoSuchElementException {
            if (this.entry == null || this.entry.getValue() == null) {
                throw new NoSuchElementException("No value present");
            }
            return (V)this.valueDataConversion.fromStorage(this.entry.getValue());
        }

        @Override
        public <T extends MetaParam> Optional<T> findMetaParam(Class<T> type) {
            Metadata metadata = this.entry.getMetadata();
            if (metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        public String toString() {
            return "EntryBackedReadOnlyView{entry=" + this.entry + '}';
        }
    }

    public static interface AccessLoggingReadWriteView<K, V>
    extends EntryView.ReadWriteEntryView<K, V> {
        public boolean isRead();
    }
}

