/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Collection;
import java.util.Map;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.FunctionalCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.TxReadOnlyKeyCommand;
import org.infinispan.commands.functional.TxReadOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.impl.EntryFactory;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.responses.Response;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;

public class EntryWrappingInterceptor
extends DDAsyncInterceptor {
    @Inject
    private EntryFactory entryFactory;
    @Inject
    private InternalDataContainer<Object, Object> dataContainer;
    @Inject
    protected ClusteringDependentLogic cdl;
    @Inject
    private VersionGenerator versionGenerator;
    @Inject
    protected DistributionManager distributionManager;
    @Inject
    private ComponentRef<StateConsumer> stateConsumer;
    @Inject
    private StateTransferLock stateTransferLock;
    @Inject
    private ComponentRef<XSiteStateConsumer> xSiteStateConsumer;
    @Inject
    private GroupManager groupManager;
    @Inject
    private CacheNotifier notifier;
    @Inject
    private KeyPartitioner keyPartitioner;
    private final EntryWrappingVisitor entryWrappingVisitor = new EntryWrappingVisitor();
    private boolean isInvalidation;
    private boolean isSync;
    private boolean useRepeatableRead;
    private boolean isVersioned;
    private static final Log log = LogFactory.getLog(EntryWrappingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final long EVICT_FLAGS_BITSET = FlagBitSets.SKIP_OWNERSHIP_CHECK | FlagBitSets.CACHE_MODE_LOCAL;
    private boolean totalOrder;
    private final InvocationSuccessAction dataReadReturnHandler = (rCtx, rCommand, rv) -> {
        AbstractDataCommand dataCommand = (AbstractDataCommand)rCommand;
        if (rCtx.isInTxScope() && this.useRepeatableRead) {
            this.addVersionRead(rCtx, dataCommand);
        }
        if (rv != null && !(rv instanceof Response)) {
            Object value = dataCommand instanceof GetCacheEntryCommand ? ((CacheEntry)rv).getValue() : rv;
            this.notifier.notifyCacheEntryVisited(dataCommand.getKey(), value, true, rCtx, dataCommand);
            this.notifier.notifyCacheEntryVisited(dataCommand.getKey(), value, false, rCtx, dataCommand);
        }
    };
    private final InvocationSuccessAction commitEntriesSuccessHandler = (rCtx, rCommand, rv) -> this.commitContextEntries(rCtx, null);
    private final InvocationFinallyAction commitEntriesFinallyHandler = this::commitEntriesFinally;
    private final InvocationSuccessFunction prepareHandler = this::prepareHandler;
    private final InvocationSuccessAction applyAndFixVersion = this::applyAndFixVersion;
    private final InvocationSuccessAction applyAndFixVersionForMany = this::applyAndFixVersionForMany;

    private void addVersionRead(InvocationContext rCtx, AbstractDataCommand dataCommand) {
        CacheEntry cacheEntry = rCtx.lookupEntry(dataCommand.getKey());
        cacheEntry.setSkipLookup(true);
        if (this.isVersioned && ((MVCCEntry)cacheEntry).isRead()) {
            this.addVersionRead((TxInvocationContext)rCtx, cacheEntry, dataCommand.getKey());
        }
    }

    @Start
    public void start() {
        this.isInvalidation = this.cacheConfiguration.clustering().cacheMode().isInvalidation();
        this.isSync = this.cacheConfiguration.clustering().cacheMode().isSynchronous();
        this.useRepeatableRead = this.cacheConfiguration.transaction().transactionMode().isTransactional() && this.cacheConfiguration.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ || this.cacheConfiguration.clustering().cacheMode().isScattered();
        this.isVersioned = Configurations.isTxVersioned(this.cacheConfiguration);
        this.totalOrder = this.cacheConfiguration.transaction().transactionProtocol().isTotalOrder();
    }

    private boolean ignoreOwnership(FlagAffectedCommand command) {
        return this.distributionManager == null || command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_OWNERSHIP_CHECK);
    }

    protected boolean canRead(DataCommand command) {
        return this.distributionManager.getCacheTopology().isSegmentReadOwner(command.getSegment());
    }

    protected boolean canReadKey(Object key) {
        return this.distributionManager.getCacheTopology().isReadOwner(key);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        return this.wrapEntriesForPrepareAndApply(ctx, command, this.prepareHandler);
    }

    private Object prepareHandler(InvocationContext ctx, VisitableCommand command, Object rv) {
        if (this.shouldCommitDuringPrepare((PrepareCommand)command, (TxInvocationContext)ctx)) {
            return this.invokeNextThenAccept(ctx, command, this.commitEntriesSuccessHandler);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, this.commitEntriesFinallyHandler);
    }

    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    private Object visitDataReadCommand(InvocationContext ctx, AbstractDataCommand command) {
        Object key = command.getKey();
        this.entryFactory.wrapEntryForReading(ctx, key, command.getSegment(), this.ignoreOwnership(command) || this.canRead(command));
        return this.invokeNextThenAccept(ctx, command, this.dataReadReturnHandler);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        boolean ignoreOwnership = this.ignoreOwnership(command);
        for (Object key : command.getKeys()) {
            this.entryFactory.wrapEntryForReading(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key));
        }
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            GetAllCommand getAllCommand = (GetAllCommand)rCommand;
            if (this.useRepeatableRead) {
                for (Object key : getAllCommand.getKeys()) {
                    CacheEntry cacheEntry = rCtx.lookupEntry(key);
                    if (cacheEntry == null) {
                        if (!trace) continue;
                        log.tracef(t, "Missing entry for " + key, new Object[0]);
                        continue;
                    }
                    cacheEntry.setSkipLookup(true);
                }
            }
            if (t == null && rv instanceof Map) {
                log.tracef("Notifying getAll? %s; result %s", (Object)(!command.hasAnyFlag(FlagBitSets.SKIP_LISTENER_NOTIFICATION) ? 1 : 0), rv);
                Map map = (Map)rv;
                if (!command.hasAnyFlag(FlagBitSets.SKIP_LISTENER_NOTIFICATION)) {
                    for (Map.Entry entry : map.entrySet()) {
                        Object value = entry.getValue();
                        if (value == null) continue;
                        value = command.isReturnEntries() ? ((CacheEntry)value).getValue() : entry.getValue();
                        this.notifier.notifyCacheEntryVisited(entry.getKey(), value, true, rCtx, getAllCommand);
                        this.notifier.notifyCacheEntryVisited(entry.getKey(), value, false, rCtx, getAllCommand);
                    }
                }
            }
        });
    }

    @Override
    public final Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        if (command.getKeys() != null) {
            for (Object key : command.getKeys()) {
                this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), true, false);
            }
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
            if (this.stateConsumer.running() != null) {
                this.stateConsumer.running().stopApplyingState(((ClearCommand)rCommand).getTopologyId());
            }
            if (this.xSiteStateConsumer.running() != null) {
                this.xSiteStateConsumer.running().endStateTransfer(null);
            }
            if (!rCtx.isInTxScope()) {
                ClearCommand clearCommand = (ClearCommand)rCommand;
                this.applyChanges(rCtx, clearCommand);
            }
            if (trace) {
                log.tracef("The return value is %s", rv);
            }
        });
    }

    @Override
    public Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        for (Object key : command.getKeys()) {
            this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), false, false);
            if (!trace) continue;
            log.tracef("Entry to be removed: %s", (Object)Util.toStr(key));
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    @Override
    public final Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command);
    }

    private void wrapEntryIfNeeded(InvocationContext ctx, AbstractDataWriteCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getKey());
        }
        this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), command.getSegment(), this.ignoreOwnership(command) || this.canRead(command), command.loadType() != VisitableCommand.LoadType.DONT_LOAD);
    }

    private void removeFromContextOnRetry(InvocationContext ctx, Object key) {
        if (this.useRepeatableRead) {
            MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(key);
            if (trace) {
                log.tracef("This is a retry - resetting previous value in entry %s", (Object)entry);
            }
            if (entry != null) {
                entry.resetCurrentValue();
            }
        } else {
            if (trace) {
                log.tracef("This is a retry - removing looked up entry %s", (Object)ctx.lookupEntry(key));
            }
            ctx.removeLookedUpEntry(key);
        }
    }

    private void removeFromContextOnRetry(InvocationContext ctx, Collection<?> keys) {
        if (this.useRepeatableRead) {
            if (trace) {
                log.tracef("This is a retry - resetting previous values for %s", (Object)keys);
            }
            for (Object key : keys) {
                MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(key);
                if (entry == null) continue;
                entry.resetCurrentValue();
            }
        } else {
            ctx.removeLookedUpEntries(keys);
        }
    }

    @Override
    public final Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command);
    }

    @Override
    public Object visitRemoveExpiredCommand(InvocationContext ctx, RemoveExpiredCommand command) throws Throwable {
        this.entryFactory.wrapEntryForExpired(ctx, command.getKey(), command.getSegment(), this.ignoreOwnership(command) || this.canRead(command));
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command);
    }

    @Override
    public final Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        boolean ignoreOwnership = this.ignoreOwnership(command);
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        for (Object key : command.getMap().keySet()) {
            this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key), command.loadType() != VisitableCommand.LoadType.DONT_LOAD);
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        command.setFlagsBitSet(command.getFlagsBitSet() | EVICT_FLAGS_BITSET);
        return this.visitRemoveCommand(ctx, command);
    }

    @Override
    public Object visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        if (command.isGroupOwner()) {
            this.dataContainer.forEach(internalCacheEntry -> {
                Object key = internalCacheEntry.getKey();
                if (!command.getGroupName().equals(this.groupManager.getGroup(key)) || ctx.lookupEntry(key) != null) {
                    return;
                }
                if (internalCacheEntry.getValue() != null) {
                    InvocationContext invocationContext = ctx;
                    synchronized (invocationContext) {
                        this.entryFactory.wrapExternalEntry(ctx, key, (CacheEntry)internalCacheEntry, true, false);
                    }
                }
            });
        }
        if (ctx.isInTxScope() && this.useRepeatableRead) {
            return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
                TxInvocationContext txCtx = (TxInvocationContext)rCtx;
                ctx.forEachEntry((key, entry) -> {
                    entry.setSkipLookup(true);
                    if (this.isVersioned && ((MVCCEntry)entry).isRead()) {
                        this.addVersionRead(txCtx, (CacheEntry)entry, key);
                    }
                });
            });
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        if (command instanceof TxReadOnlyKeyCommand) {
            this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), command.getSegment(), this.ignoreOwnership(command) || this.canRead(command), true);
        } else {
            this.entryFactory.wrapEntryForReading(ctx, command.getKey(), command.getSegment(), this.ignoreOwnership(command) || this.canRead(command));
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        boolean ignoreOwnership = this.ignoreOwnership(command);
        if (command instanceof TxReadOnlyManyCommand) {
            for (Object key : command.getKeys()) {
                this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), this.ignoreOwnership(command) || this.canReadKey(key), true);
            }
        } else {
            for (Object key : command.getKeys()) {
                this.entryFactory.wrapEntryForReading(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key));
            }
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        boolean ignoreOwnership = this.ignoreOwnership(command);
        for (Object key : command.getArguments().keySet()) {
            this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key), false);
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        boolean ignoreOwnership = this.ignoreOwnership(command);
        for (Object key : command.getAffectedKeys()) {
            this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key), false);
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        boolean ignoreOwnership = this.ignoreOwnership(command);
        for (Object key : command.getAffectedKeys()) {
            this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key), true);
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        boolean ignoreOwnership = this.ignoreOwnership(command);
        for (Object key : command.getAffectedKeys()) {
            this.entryFactory.wrapEntryForWriting(ctx, key, this.keyPartitioner.getSegment(key), ignoreOwnership || this.canReadKey(key), true);
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    protected final void commitContextEntries(InvocationContext ctx, FlagAffectedCommand command) {
        Flag stateTransferFlag = FlagBitSets.extractStateTransferFlag(ctx, command);
        if (ctx instanceof SingleKeyNonTxInvocationContext) {
            SingleKeyNonTxInvocationContext singleKeyCtx = (SingleKeyNonTxInvocationContext)ctx;
            this.commitEntryIfNeeded(ctx, command, singleKeyCtx.getCacheEntry(), stateTransferFlag);
        } else {
            ctx.forEachEntry((key, entry) -> {
                if (!this.commitEntryIfNeeded(ctx, command, (CacheEntry)entry, stateTransferFlag) && trace) {
                    if (entry == null) {
                        log.tracef("Entry for key %s is null : not calling commitUpdate", (Object)Util.toStr(key));
                    } else {
                        log.tracef("Entry for key %s is not changed(%s): not calling commitUpdate", (Object)Util.toStr(key), entry);
                    }
                }
            });
        }
    }

    protected void commitContextEntry(CacheEntry entry, InvocationContext ctx, FlagAffectedCommand command, Flag stateTransferFlag, boolean l1Invalidation) {
        this.cdl.commitEntry(entry, command, ctx, stateTransferFlag, l1Invalidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChanges(InvocationContext ctx, WriteCommand command) {
        this.stateTransferLock.acquireSharedTopologyLock();
        try {
            if (!this.isInvalidation) {
                boolean syncRpc;
                boolean bl = syncRpc = this.isSync && !command.hasAnyFlag(FlagBitSets.FORCE_ASYNCHRONOUS) || command.hasAnyFlag(FlagBitSets.FORCE_SYNCHRONOUS);
                if (command.isSuccessful() && this.distributionManager != null) {
                    int commandTopologyId = command.getTopologyId();
                    int currentTopologyId = this.distributionManager.getCacheTopology().getTopologyId();
                    if (syncRpc && currentTopologyId != commandTopologyId && commandTopologyId != -1 && (!ctx.isOriginLocal() || !(command instanceof DataCommand) || ctx.hasLockedKey(((DataCommand)((Object)command)).getKey()))) {
                        if (trace) {
                            log.tracef("Cache topology changed while the command was executing: expected %d, got %d", commandTopologyId, currentTopologyId);
                        }
                        command.setValueMatcher(command.getValueMatcher().matcherForRetry());
                        throw new OutdatedTopologyException("Cache topology changed while the command was executing: expected " + commandTopologyId + ", got " + currentTopologyId);
                    }
                }
            }
            this.commitContextEntries(ctx, command);
        }
        finally {
            this.stateTransferLock.releaseSharedTopologyLock();
        }
    }

    protected Object setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(InvocationContext ctx, WriteCommand command) {
        return this.invokeNextThenAccept(ctx, command, this.applyAndFixVersionForMany);
    }

    private void applyAndFixVersionForMany(InvocationContext ctx, VisitableCommand cmd, Object rv) {
        WriteCommand writeCommand = (WriteCommand)cmd;
        if (!ctx.isInTxScope()) {
            this.applyChanges(ctx, writeCommand);
            return;
        }
        if (trace) {
            log.tracef("The return value is %s", (Object)Util.toStr(rv));
        }
        if (this.useRepeatableRead) {
            boolean addVersionRead = this.isVersioned && writeCommand.loadType() != VisitableCommand.LoadType.DONT_LOAD;
            TxInvocationContext txCtx = (TxInvocationContext)ctx;
            for (Object key : writeCommand.getAffectedKeys()) {
                CacheEntry cacheEntry = ctx.lookupEntry(key);
                if (cacheEntry == null) continue;
                cacheEntry.setSkipLookup(true);
                if (addVersionRead && ((MVCCEntry)cacheEntry).isRead()) {
                    this.addVersionRead(txCtx, cacheEntry, key);
                }
                ((MVCCEntry)cacheEntry).updatePreviousValue();
            }
        }
    }

    private void addVersionRead(TxInvocationContext rCtx, CacheEntry cacheEntry, Object key) {
        EntryVersion version;
        if (cacheEntry != null && cacheEntry.getMetadata() != null) {
            version = cacheEntry.getMetadata().version();
            if (trace) {
                log.tracef("Adding version read %s for key %s", (Object)version, key);
            }
        } else {
            version = this.versionGenerator.nonExistingVersion();
            if (trace) {
                log.tracef("Adding non-existent version read for key %s", key);
            }
        }
        ((AbstractCacheTransaction)rCtx.getCacheTransaction()).addVersionRead(key, version);
    }

    protected Object setSkipRemoteGetsAndInvokeNextForDataCommand(InvocationContext ctx, DataWriteCommand command) {
        return this.invokeNextThenAccept(ctx, command, this.applyAndFixVersion);
    }

    private void applyAndFixVersion(InvocationContext ctx, VisitableCommand cmd, Object rv) {
        CacheEntry cacheEntry;
        DataWriteCommand dataWriteCommand = (DataWriteCommand)cmd;
        if (!ctx.isInTxScope()) {
            this.applyChanges(ctx, dataWriteCommand);
            return;
        }
        if (trace) {
            log.tracef("The return value is %s", rv);
        }
        if (this.useRepeatableRead && (cacheEntry = ctx.lookupEntry(dataWriteCommand.getKey())) != null) {
            cacheEntry.setSkipLookup(true);
            if (this.isVersioned && dataWriteCommand.loadType() != VisitableCommand.LoadType.DONT_LOAD && ((MVCCEntry)cacheEntry).isRead()) {
                this.addVersionRead((TxInvocationContext)ctx, cacheEntry, dataWriteCommand.getKey());
            }
            ((MVCCEntry)cacheEntry).updatePreviousValue();
        }
    }

    private void commitEntriesFinally(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable t) {
        if (t instanceof OutdatedTopologyException) {
            return;
        }
        this.commitContextEntries(rCtx, null);
    }

    private boolean commitEntryIfNeeded(InvocationContext ctx, FlagAffectedCommand command, CacheEntry entry, Flag stateTransferFlag) {
        if (entry == null) {
            return false;
        }
        boolean l1Invalidation = command instanceof InvalidateL1Command;
        if (entry.isChanged()) {
            if (trace) {
                log.tracef("About to commit entry %s", (Object)entry);
            }
            this.commitContextEntry(entry, ctx, command, stateTransferFlag, l1Invalidation);
            return true;
        }
        return false;
    }

    protected boolean shouldCommitDuringPrepare(PrepareCommand command, TxInvocationContext ctx) {
        return this.totalOrder ? !(!command.isOnePhaseCommit() || ctx.isOriginLocal() && command.hasModifications()) : command.isOnePhaseCommit();
    }

    protected final Object wrapEntriesForPrepareAndApply(TxInvocationContext ctx, PrepareCommand command, InvocationSuccessFunction handler) throws Throwable {
        if (!ctx.isOriginLocal() || command.isReplayEntryWrapping()) {
            return this.applyModificationsAndThen(ctx, command, command.getModifications(), 0, handler);
        }
        if (ctx.isOriginLocal()) {
            for (WriteCommand mod : command.getModifications()) {
                if (mod.getTopologyId() >= command.getTopologyId() || !(mod instanceof FunctionalCommand)) continue;
                log.trace("Clearing looked up entries and replaying whole transaction");
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).clearLookedUpEntries();
                return this.applyModificationsAndThen(ctx, command, command.getModifications(), 0, handler);
            }
        }
        return handler.apply(ctx, command, null);
    }

    private Object applyModificationsAndThen(TxInvocationContext ctx, PrepareCommand command, WriteCommand[] modifications, int startIndex, InvocationSuccessFunction handler) throws Throwable {
        for (int i = startIndex; i < modifications.length; ++i) {
            Object result;
            WriteCommand c = modifications[i];
            c.setTopologyId(command.getTopologyId());
            if (c.hasAnyFlag(FlagBitSets.PUT_FOR_X_SITE_STATE_TRANSFER)) {
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).setStateTransferFlag(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
            }
            if (EntryWrappingInterceptor.isSuccessfullyDone(result = c.acceptVisitor(ctx, this.entryWrappingVisitor))) continue;
            int nextIndex = i + 1;
            if (nextIndex >= modifications.length) {
                return EntryWrappingInterceptor.makeStage(result).thenApply(ctx, command, handler);
            }
            return EntryWrappingInterceptor.makeStage(result).thenApply(ctx, command, (rCtx, rCommand, rv) -> this.applyModificationsAndThen(ctx, command, modifications, nextIndex, handler));
        }
        return handler.apply(ctx, command, null);
    }

    private final class EntryWrappingVisitor
    extends AbstractVisitor {
        private EntryWrappingVisitor() {
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            return this.handleWriteManyCommand(ctx, command);
        }

        @Override
        public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
            return this.handleWriteManyCommand(ctx, command);
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
            return this.handleWriteManyCommand(ctx, command);
        }

        @Override
        public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
            return this.handleWriteCommand(ctx, command);
        }

        @Override
        public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
            return this.handleWriteManyCommand(ctx, command);
        }

        @Override
        public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
            return this.handleWriteManyCommand(ctx, command);
        }

        @Override
        public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
            return this.handleWriteManyCommand(ctx, command);
        }

        private Object handleWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
            EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), command.getSegment(), EntryWrappingInterceptor.this.ignoreOwnership(command) || EntryWrappingInterceptor.this.canRead(command), command.loadType() != VisitableCommand.LoadType.DONT_LOAD);
            return EntryWrappingInterceptor.this.invokeNext(ctx, command);
        }

        private Object handleWriteManyCommand(InvocationContext ctx, WriteCommand command) {
            boolean ignoreOwnership = EntryWrappingInterceptor.this.ignoreOwnership(command);
            for (Object key : command.getAffectedKeys()) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, key, EntryWrappingInterceptor.this.keyPartitioner.getSegment(key), ignoreOwnership || EntryWrappingInterceptor.this.canReadKey(key), command.loadType() != VisitableCommand.LoadType.DONT_LOAD);
            }
            return EntryWrappingInterceptor.this.invokeNext(ctx, command);
        }
    }
}

