/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.InvocationExceptionFunction;
import org.infinispan.interceptors.distribution.ConcurrentChangeException;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RetryingEntryWrappingInterceptor
extends EntryWrappingInterceptor {
    private static final Log log = LogFactory.getLog(EntryWrappingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private final InvocationExceptionFunction handleDataWriteReturn = this::handleDataWriteReturn;
    private final InvocationExceptionFunction handleManyWriteReturn = this::handleManyWriteReturn;

    @Override
    protected Object setSkipRemoteGetsAndInvokeNextForDataCommand(InvocationContext ctx, DataWriteCommand command) {
        return this.invokeNextAndExceptionally(ctx, command, this.handleDataWriteReturn);
    }

    Object handleDataWriteReturn(InvocationContext ctx, VisitableCommand command, Throwable throwable) throws Throwable {
        if (throwable instanceof ConcurrentChangeException) {
            if (trace) {
                log.tracef(throwable, "Retrying %s after concurrent change", (Object)command);
            }
            DataWriteCommand dataWriteCommand = (DataWriteCommand)command;
            ctx.removeLookedUpEntry(dataWriteCommand.getKey());
            return this.visitCommand(ctx, dataWriteCommand);
        }
        throw throwable;
    }

    @Override
    protected Object setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(InvocationContext ctx, WriteCommand command) {
        return this.invokeNextAndExceptionally(ctx, command, this.handleManyWriteReturn);
    }

    Object handleManyWriteReturn(InvocationContext ctx, VisitableCommand command, Throwable throwable) throws Throwable {
        if (throwable instanceof ConcurrentChangeException) {
            if (trace) {
                log.tracef(throwable, "Retrying %s after concurrent change", (Object)command);
            }
            for (Object key : ((WriteCommand)command).getAffectedKeys()) {
                MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(key);
                if (entry.isCommitted()) {
                    entry.resetCurrentValue();
                    continue;
                }
                ctx.removeLookedUpEntry(key);
            }
            return this.visitCommand(ctx, command);
        }
        throw throwable;
    }
}

