/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.totalorder;

import java.util.Collection;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderPrepareCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TotalOrderRemoteTransactionState;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.totalorder.TotalOrderManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TotalOrderInterceptor
extends DDAsyncInterceptor {
    private static final Log log = LogFactory.getLog(TotalOrderInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    private TransactionTable transactionTable;
    @Inject
    private TotalOrderManager totalOrderManager;
    @Inject
    private ClusteringDependentLogic clusteringDependentLogic;
    @Inject
    @ComponentName(value="org.infinispan.executors.remote")
    private BlockingTaskAwareExecutorService executorService;

    @Override
    public final Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debugf("Prepare received. Transaction=%s, Affected keys=%s, Local=%s", (Object)command.getGlobalTransaction().globalId(), (Object)Util.toStr(command.getAffectedKeys()), (Object)ctx.isOriginLocal());
        }
        if (!(command instanceof TotalOrderPrepareCommand)) {
            throw new IllegalStateException("TotalOrderInterceptor can only handle TotalOrderPrepareCommand");
        }
        TotalOrderRemoteTransactionState state = this.getTransactionState(ctx);
        try {
            this.simulateLocking(ctx, command, this.clusteringDependentLogic);
            if (ctx.isOriginLocal()) {
                return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
                    if (t != null) {
                        this.rollbackTxOnPrepareException(rCtx, (PrepareCommand)rCommand, t);
                    }
                });
            }
            state.preparing();
            if (state.isRollbackReceived()) {
                this.transactionTable.removeRemoteTransaction(command.getGlobalTransaction());
                throw new CacheException("Cannot prepare transaction" + command.getGlobalTransaction().globalId() + ". it was already marked as rollback");
            }
            if (state.isCommitReceived()) {
                log.tracef("Transaction %s marked for commit, skipping the write skew check and forcing 1PC", (Object)command.getGlobalTransaction().globalId());
                ((TotalOrderPrepareCommand)((Object)command)).markSkipWriteSkewCheck();
                ((TotalOrderPrepareCommand)((Object)command)).markAsOnePhaseCommit();
            }
            if (trace) {
                log.tracef("Validating transaction %s ", (Object)command.getGlobalTransaction().globalId());
            }
            return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> this.afterPrepare((TxInvocationContext)rCtx, (PrepareCommand)rCommand, state, t));
        }
        catch (Throwable t2) {
            this.afterPrepare(ctx, command, state, t2);
            throw t2;
        }
    }

    private void rollbackTxOnPrepareException(InvocationContext ctx, PrepareCommand command, Throwable throwable) {
        if (log.isDebugEnabled()) {
            log.debugf(throwable, "Exception while preparing for transaction %s. Local=%s", (Object)command.getGlobalTransaction().globalId(), (Object)ctx.isOriginLocal());
        }
        if (command.isOnePhaseCommit()) {
            this.transactionTable.remoteTransactionRollback(command.getGlobalTransaction());
        }
    }

    private void afterPrepare(TxInvocationContext ctx, PrepareCommand command, TotalOrderRemoteTransactionState state, Throwable t) {
        if (t == null && command.isOnePhaseCommit()) {
            this.totalOrderManager.release(state);
        }
        state.prepared();
        if (t != null) {
            this.rollbackTxOnPrepareException(ctx, command, t);
        }
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.visitSecondPhaseCommand(ctx, command, false);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.visitSecondPhaseCommand(ctx, command, true);
    }

    @Override
    public final Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        throw new UnsupportedOperationException("Lock interface not supported with total order protocol");
    }

    private Object visitSecondPhaseCommand(TxInvocationContext context, AbstractTransactionBoundaryCommand command, boolean commit) throws Throwable {
        GlobalTransaction gtx = command.getGlobalTransaction();
        if (trace) {
            log.tracef("Second phase command received. Commit?=%s Transaction=%s, Local=%s", (Object)commit, (Object)gtx.globalId(), (Object)context.isOriginLocal());
        }
        TotalOrderRemoteTransactionState state = this.getTransactionState(context);
        try {
            if (!this.processSecondCommand(state, commit) && !context.isOriginLocal()) {
                return null;
            }
        }
        catch (Throwable t2) {
            this.finishSecondPhaseCommand(commit, state, context, command);
            throw t2;
        }
        return this.invokeNextAndFinally(context, command, (rCtx, rCommand, rv, t) -> this.finishSecondPhaseCommand(commit, state, rCtx, (AbstractTransactionBoundaryCommand)rCommand));
    }

    private void finishSecondPhaseCommand(boolean commit, TotalOrderRemoteTransactionState state, InvocationContext ctx, AbstractTransactionBoundaryCommand txCommand) {
        if (state != null && state.isFinished()) {
            this.totalOrderManager.release(state);
            if (commit) {
                this.transactionTable.remoteTransactionCommitted(txCommand.getGlobalTransaction(), false);
            } else {
                this.transactionTable.remoteTransactionRollback(txCommand.getGlobalTransaction());
            }
            if (ctx.isOriginLocal()) {
                this.executorService.checkForReadyTasks();
            }
        }
    }

    private TotalOrderRemoteTransactionState getTransactionState(TxInvocationContext context) {
        if (!context.isOriginLocal()) {
            return ((RemoteTransaction)context.getCacheTransaction()).getTransactionState();
        }
        RemoteTransaction remoteTransaction = this.transactionTable.getRemoteTransaction(context.getGlobalTransaction());
        return remoteTransaction == null ? null : remoteTransaction.getTransactionState();
    }

    private boolean processSecondCommand(TotalOrderRemoteTransactionState state, boolean commit) {
        if (state == null) {
            return true;
        }
        try {
            return state.waitUntilPrepared(commit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.timeoutWaitingUntilTransactionPrepared(state.getGlobalTransaction().globalId());
            return false;
        }
    }

    private void simulateLocking(TxInvocationContext context, PrepareCommand command, ClusteringDependentLogic clusteringDependentLogic) {
        Collection<?> affectedKeys = command.getAffectedKeys();
        context.addAllAffectedKeys(command.getAffectedKeys());
        context.clearLockedKeys();
        for (Object k : affectedKeys) {
            if (!clusteringDependentLogic.getCacheTopology().getDistribution(k).isPrimary()) continue;
            context.addLockedKey(k);
        }
    }
}

