/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import javax.transaction.Transaction;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupSender;

public class BaseBackupInterceptor
extends DDAsyncInterceptor {
    @Inject
    protected BackupSender backupSender;
    @Inject
    protected TransactionTable txTable;
    protected static final Log log = LogFactory.getLog(BaseBackupInterceptor.class);
    protected static final boolean trace = log.isTraceEnabled();
    private final InvocationSuccessAction handleClearReturn = this::handleClearReturn;

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (!ctx.isOriginLocal() || this.skipXSiteBackup(command)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenAccept(ctx, command, this.handleClearReturn);
    }

    private void handleClearReturn(InvocationContext ctx, VisitableCommand rCommand, Object rv) throws Throwable {
        this.backupSender.processResponses(this.backupSender.backupWrite((ClearCommand)rCommand), rCommand);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!this.shouldInvokeRemoteTxCommand(ctx)) {
            return this.invokeNext(ctx, command);
        }
        boolean isTxFromRemoteSite = this.isTxFromRemoteSite(command.getGlobalTransaction());
        if (isTxFromRemoteSite) {
            return this.invokeNext(ctx, command);
        }
        BackupResponse backupResponse = this.backupSender.backupPrepare(command, (AbstractCacheTransaction)ctx.getCacheTransaction());
        return this.processBackupResponse(ctx, command, backupResponse);
    }

    protected Object processBackupResponse(TxInvocationContext ctx, VisitableCommand command, BackupResponse backupResponse) {
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
            Transaction transaction = ((TxInvocationContext)rCtx).getTransaction();
            this.backupSender.processResponses(backupResponse, rCommand, transaction);
        });
    }

    protected boolean isTxFromRemoteSite(GlobalTransaction gtx) {
        LocalTransaction remoteTx = this.txTable.getLocalTransaction(gtx);
        return remoteTx != null && remoteTx.isFromRemoteSite();
    }

    protected boolean shouldInvokeRemoteTxCommand(TxInvocationContext ctx) {
        boolean shouldBackupRemotely = ctx.isOriginLocal() && ctx.hasModifications() && !((AbstractCacheTransaction)ctx.getCacheTransaction()).isFromStateTransfer();
        this.getLog().tracef("Should backup remotely? %s", (Object)shouldBackupRemotely);
        return shouldBackupRemotely;
    }

    protected final boolean skipXSiteBackup(FlagAffectedCommand command) {
        return command.hasAnyFlag(FlagBitSets.SKIP_XSITE_BACKUP);
    }

    protected Log getLog() {
        return log;
    }
}

