/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.JmxUtil;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.AbstractJmxRegistration;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.jmx.SecurityActions;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@SurvivesRestarts
@Scope(value=Scopes.GLOBAL)
public class CacheManagerJmxRegistration
extends AbstractJmxRegistration {
    private static final Log log = LogFactory.getLog(CacheManagerJmxRegistration.class);
    public static final String CACHE_MANAGER_JMX_GROUP = "type=CacheManager";
    private boolean needToUnregister = false;
    private boolean stopped;
    private Collection<ResourceDMBean> resourceDMBeans;

    public void start() {
        this.initMBeanServer(this.globalConfig);
        if (this.mBeanServer != null) {
            Collection<ComponentRef<?>> components = this.basicComponentRegistry.getRegisteredComponents();
            this.resourceDMBeans = Collections.synchronizedCollection(this.getResourceDMBeansFromComponents(components));
            this.registrar.registerMBeans(this.resourceDMBeans);
            this.needToUnregister = true;
        }
        this.stopped = false;
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        if (this.needToUnregister) {
            try {
                this.unregisterMBeans(this.resourceDMBeans);
                this.needToUnregister = false;
            }
            catch (Exception e) {
                log.problemsUnregisteringMBeans(e);
            }
        }
        this.stopped = true;
    }

    @Override
    protected ComponentsJmxRegistration buildRegistrar() {
        String groupName = "type=CacheManager," + ComponentsJmxRegistration.NAME_KEY + "=" + ObjectName.quote(this.globalConfig.globalJmxStatistics().cacheManagerName());
        ComponentsJmxRegistration registrar = new ComponentsJmxRegistration(this.mBeanServer, groupName);
        this.updateDomain(registrar, this.mBeanServer, groupName);
        return registrar;
    }

    protected void updateDomain(ComponentsJmxRegistration registrar, MBeanServer mBeanServer, String groupName) {
        if (this.jmxDomain == null) {
            this.jmxDomain = JmxUtil.buildJmxDomain(this.globalConfig.globalJmxStatistics().domain(), mBeanServer, groupName);
            String configJmxDomain = this.globalConfig.globalJmxStatistics().domain();
            if (!this.jmxDomain.equals(configJmxDomain) && !this.globalConfig.globalJmxStatistics().allowDuplicateDomains()) {
                throw log.jmxMBeanAlreadyRegistered(groupName, configJmxDomain);
            }
        }
        registrar.setJmxDomain(this.jmxDomain);
    }

    public void unregisterCacheMBean(String cacheName, String cacheModeString) {
        if (this.mBeanServer != null) {
            String groupName = "type=Cache," + this.getCacheJmxName(cacheName, cacheModeString) + ",manager=" + ObjectName.quote(this.globalConfig.globalJmxStatistics().cacheManagerName());
            String pattern = this.jmxDomain + ":" + groupName + ",*";
            try {
                Set<ObjectName> names = SecurityActions.queryNames(new ObjectName(pattern), null, this.mBeanServer);
                for (ObjectName name : names) {
                    JmxUtil.unregisterMBean(name, this.mBeanServer);
                }
            }
            catch (MBeanRegistrationException e) {
                log.unableToUnregisterMBeanWithPattern(pattern, e);
            }
            catch (InstanceNotFoundException e) {
            }
            catch (MalformedObjectNameException e) {
                String message = "Malformed pattern " + pattern;
                throw new CacheException(message, e);
            }
            catch (Exception e) {
                throw new CacheException(e);
            }
        }
    }

    String getCacheJmxName(String cacheName, String cacheModeString) {
        return ComponentsJmxRegistration.NAME_KEY + "=" + ObjectName.quote(cacheName + "(" + cacheModeString.toLowerCase() + ")");
    }

    public void registerMBean(Object managedComponent) {
        ResourceDMBean resourceDMBean = this.getResourceDMBean(managedComponent);
        this.registrar.registerMBeans(Collections.singleton(resourceDMBean));
        this.resourceDMBeans.add(resourceDMBean);
    }
}

