/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.DoubleSummaryStatistics;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.NotSerializableException;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.exts.SecurityActions;

public class DoubleSummaryStatisticsExternalizer
extends AbstractExternalizer<DoubleSummaryStatistics> {
    private static final String CONSTRUCTOR_CALL_ERROR_MSG = "Unable to create instance of %s via [%s] with parameters (%s, %s, %s, %s)";
    static final Field countField;
    static final Field sumField;
    static final Field minField;
    static final Field maxField;
    static final boolean canSerialize;
    static final Constructor<DoubleSummaryStatistics> constructor;

    @Override
    public Set<Class<? extends DoubleSummaryStatistics>> getTypeClasses() {
        return Util.asSet(DoubleSummaryStatistics.class);
    }

    private void verifySerialization() {
        if (!canSerialize) {
            throw new NotSerializableException("DoubleSummaryStatistics is not serializable, fields not available!");
        }
    }

    @Override
    public void writeObject(ObjectOutput output, DoubleSummaryStatistics object) throws IOException {
        this.verifySerialization();
        output.writeLong(object.getCount());
        output.writeDouble(object.getSum());
        output.writeDouble(0.0);
        output.writeDouble(0.0);
        output.writeDouble(object.getMin());
        output.writeDouble(object.getMax());
    }

    @Override
    public DoubleSummaryStatistics readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        DoubleSummaryStatistics summaryStatistics;
        this.verifySerialization();
        long count = input.readLong();
        double sum = input.readDouble();
        double sumCompensation = input.readDouble();
        double simpleSum = input.readDouble();
        double min = input.readDouble();
        double max = input.readDouble();
        if (constructor != null) {
            try {
                summaryStatistics = constructor.newInstance(count, min, max, sum);
            }
            catch (ReflectiveOperationException e) {
                throw new IOException(String.format(CONSTRUCTOR_CALL_ERROR_MSG, DoubleSummaryStatistics.class, constructor.toString(), count, min, max, sum), e);
            }
        }
        summaryStatistics = new DoubleSummaryStatistics();
        try {
            countField.setLong(summaryStatistics, count);
            sumField.setDouble(summaryStatistics, sum);
            minField.setDouble(summaryStatistics, min);
            maxField.setDouble(summaryStatistics, max);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        return summaryStatistics;
    }

    @Override
    public Integer getId() {
        return 18;
    }

    static {
        constructor = SecurityActions.getConstructor(DoubleSummaryStatistics.class, Long.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
        if (constructor != null) {
            countField = null;
            sumField = null;
            minField = null;
            maxField = null;
            canSerialize = true;
        } else {
            countField = SecurityActions.getField(DoubleSummaryStatistics.class, "count");
            sumField = SecurityActions.getField(DoubleSummaryStatistics.class, "sum");
            minField = SecurityActions.getField(DoubleSummaryStatistics.class, "min");
            maxField = SecurityActions.getField(DoubleSummaryStatistics.class, "max");
            canSerialize = countField != null && sumField != null && minField != null && maxField != null;
        }
    }
}

