/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.LongSummaryStatistics;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.NotSerializableException;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.exts.SecurityActions;

public class LongSummaryStatisticsExternalizer
extends AbstractExternalizer<LongSummaryStatistics> {
    static final Field countField;
    static final Field sumField;
    static final Field minField;
    static final Field maxField;
    static final boolean canSerialize;
    static final Constructor<LongSummaryStatistics> constructor;

    @Override
    public Set<Class<? extends LongSummaryStatistics>> getTypeClasses() {
        return Util.asSet(LongSummaryStatistics.class);
    }

    private void verifySerialization() {
        if (!canSerialize) {
            throw new NotSerializableException("LongSummaryStatistics is not serializable, fields not available!");
        }
    }

    @Override
    public void writeObject(ObjectOutput output, LongSummaryStatistics object) throws IOException {
        this.verifySerialization();
        output.writeLong(object.getCount());
        output.writeLong(object.getSum());
        output.writeLong(object.getMin());
        output.writeLong(object.getMax());
    }

    @Override
    public LongSummaryStatistics readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        LongSummaryStatistics summaryStatistics;
        this.verifySerialization();
        long count = input.readLong();
        long sum = input.readLong();
        long min = input.readLong();
        long max = input.readLong();
        if (constructor != null) {
            try {
                summaryStatistics = constructor.newInstance(count, min, max, sum);
            }
            catch (ReflectiveOperationException e) {
                throw new IOException(e);
            }
        }
        summaryStatistics = new LongSummaryStatistics();
        try {
            countField.setLong(summaryStatistics, count);
            sumField.setLong(summaryStatistics, sum);
            minField.setLong(summaryStatistics, min);
            maxField.setLong(summaryStatistics, max);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        return summaryStatistics;
    }

    @Override
    public Integer getId() {
        return 17;
    }

    static {
        constructor = SecurityActions.getConstructor(LongSummaryStatistics.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
        if (constructor != null) {
            countField = null;
            sumField = null;
            minField = null;
            maxField = null;
            canSerialize = true;
        } else {
            countField = SecurityActions.getField(LongSummaryStatistics.class, "count");
            sumField = SecurityActions.getField(LongSummaryStatistics.class, "sum");
            minField = SecurityActions.getField(LongSummaryStatistics.class, "min");
            maxField = SecurityActions.getField(LongSummaryStatistics.class, "max");
            canSerialize = countField != null && sumField != null && minField != null && maxField != null;
        }
    }
}

