/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.distexec.DistributedExecutionCompletionService;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.notifications.cachelistener.cluster.ClusterEvent;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventCallable;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.cluster.MultiClusterEventCallable;
import org.infinispan.notifications.cachelistener.cluster.impl.SecurityActions;
import org.infinispan.remoting.transport.Address;

public class BatchingClusterEventManagerImpl<K, V>
implements ClusterEventManager<K, V> {
    @Inject
    private ComponentRef<Cache<K, V>> cache;
    private DistributedExecutorService distExecService;
    private final ThreadLocal<EventContext<K, V>> localContext = new ThreadLocal();

    @Start
    public void start() {
        this.distExecService = SecurityActions.getDefaultExecutorService(this.cache.wired());
    }

    @Override
    public void addEvents(Address target, UUID identifier, Collection<ClusterEvent<K, V>> events, boolean sync) {
        EventContext<K, V> ctx = this.localContext.get();
        if (ctx == null) {
            ctx = new UnicastEventContext();
            this.localContext.set(ctx);
        }
        ctx.addTargets(target, identifier, events, sync);
    }

    @Override
    public void sendEvents() {
        EventContext<K, V> ctx = this.localContext.get();
        if (ctx != null) {
            ctx.sendToTargets(this.distExecService);
            this.localContext.remove();
        }
    }

    @Override
    public void dropEvents() {
        this.localContext.remove();
    }

    private static class TargetEvents<K, V> {
        final Map<UUID, Collection<ClusterEvent<K, V>>> events = new HashMap<UUID, Collection<ClusterEvent<K, V>>>();
        boolean sync = false;

        private TargetEvents() {
        }
    }

    protected static class UnicastEventContext<K, V>
    implements EventContext<K, V> {
        protected final Map<Address, TargetEvents<K, V>> targets = new HashMap<Address, TargetEvents<K, V>>();

        protected UnicastEventContext() {
        }

        @Override
        public void addTargets(Address address, UUID identifier, Collection<ClusterEvent<K, V>> events, boolean sync) {
            Map<UUID, Collection<ClusterEvent<UUID, Collection<ClusterEvent<K, V>>>>> listenerEvents;
            Collection<ClusterEvent<K, V>> prevEvents;
            TargetEvents<K, V> targetEvents = this.targets.get(address);
            if (targetEvents == null) {
                targetEvents = new TargetEvents();
                this.targets.put(address, targetEvents);
            }
            if ((prevEvents = (listenerEvents = targetEvents.events).put(identifier, events)) != null) {
                events.addAll(prevEvents);
            }
            if (sync) {
                targetEvents.sync = true;
            }
        }

        @Override
        public void sendToTargets(DistributedExecutorService service) {
            DistributedExecutionCompletionService<Void> completion = new DistributedExecutionCompletionService<Void>(service);
            int syncCount = 0;
            for (Map.Entry<Address, TargetEvents<K, V>> entry : this.targets.entrySet()) {
                TargetEvents<K, V> value = entry.getValue();
                if (value.events.size() > 1) {
                    if (value.sync) {
                        completion.submit(entry.getKey(), new MultiClusterEventCallable(value.events));
                        ++syncCount;
                        continue;
                    }
                    service.submit(entry.getKey(), new MultiClusterEventCallable(value.events));
                    continue;
                }
                if (value.events.size() != 1) continue;
                Map.Entry entryValue = value.events.entrySet().iterator().next();
                if (value.sync) {
                    completion.submit(entry.getKey(), new ClusterEventCallable(entryValue.getKey(), entryValue.getValue()));
                    ++syncCount;
                    continue;
                }
                service.submit(entry.getKey(), new ClusterEventCallable(entryValue.getKey(), entryValue.getValue()));
            }
            try {
                for (int i = 0; i < syncCount; ++i) {
                    completion.take();
                }
            }
            catch (InterruptedException e) {
                throw new CacheException("Interrupted while waiting for event notifications to complete.", e);
            }
        }
    }

    private static interface EventContext<K, V> {
        public void addTargets(Address var1, UUID var2, Collection<ClusterEvent<K, V>> var3, boolean var4);

        public void sendToTargets(DistributedExecutorService var1);
    }
}

