/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.internal;

import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.internal.functions.Functions;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.rxjava.FlowableFromIntSetFunction;
import org.reactivestreams.Publisher;

public class PersistenceUtil {
    private static Log log = LogFactory.getLog(PersistenceUtil.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int SEGMENT_NOT_PROVIDED = -1;

    public static <K, V> InternalCacheEntry<K, V> loadAndStoreInDataContainer(DataContainer<K, V> dataContainer, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, AtomicReference<Boolean> isLoaded) {
        return PersistenceUtil.loadAndStoreInDataContainer(dataContainer, -1, persistenceManager, key, ctx, timeService, isLoaded);
    }

    public static <K, V> InternalCacheEntry<K, V> loadAndStoreInDataContainer(DataContainer<K, V> dataContainer, int segment, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, AtomicReference<Boolean> isLoaded) {
        return PersistenceUtil.loadAndComputeInDataContainer(dataContainer, segment, persistenceManager, key, ctx, timeService, null, isLoaded);
    }

    public static <K, V> InternalCacheEntry<K, V> loadAndComputeInDataContainer(DataContainer<K, V> dataContainer, int segment, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, DataContainer.ComputeAction<K, V> action) {
        return PersistenceUtil.loadAndComputeInDataContainer(dataContainer, segment, persistenceManager, key, ctx, timeService, action, null);
    }

    private static <K, V> InternalCacheEntry<K, V> loadAndComputeInDataContainer(DataContainer<K, V> dataContainer, int segment, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, DataContainer.ComputeAction<K, V> action, AtomicReference<Boolean> isLoaded) {
        ByRef<Object> expired = new ByRef<Object>(null);
        DataContainer.ComputeAction computeAction = (k, oldEntry, factory) -> {
            InternalCacheEntry entryToUse;
            block13: {
                if (oldEntry != null) {
                    if (oldEntry.canExpire() && oldEntry.isExpired(timeService.wallClockTime())) {
                        MarshalledEntry loaded = PersistenceUtil.loadAndCheckExpiration(persistenceManager, key, segment, ctx, false);
                        if (loaded != null) {
                            if (isLoaded != null) {
                                isLoaded.set(Boolean.TRUE);
                            }
                            entryToUse = PersistenceUtil.convert(loaded, factory);
                            break block13;
                        } else {
                            if (isLoaded != null) {
                                isLoaded.set(Boolean.FALSE);
                            }
                            expired.set(Boolean.TRUE);
                            return oldEntry;
                        }
                    }
                    if (isLoaded != null) {
                        isLoaded.set(null);
                    }
                    entryToUse = oldEntry;
                } else {
                    MarshalledEntry loaded = PersistenceUtil.loadAndCheckExpiration(persistenceManager, key, segment, ctx, true);
                    if (loaded != null) {
                        if (isLoaded != null) {
                            isLoaded.set(Boolean.TRUE);
                        }
                        entryToUse = PersistenceUtil.convert(loaded, factory);
                    } else {
                        if (isLoaded != null) {
                            isLoaded.set(Boolean.FALSE);
                        }
                        entryToUse = null;
                    }
                }
            }
            if (action != null) {
                return action.compute(k, entryToUse, factory);
            }
            return entryToUse;
        };
        InternalCacheEntry<Object, V> entry = segment != -1 && dataContainer instanceof InternalDataContainer ? ((InternalDataContainer)dataContainer).compute(segment, key, computeAction) : dataContainer.compute(key, computeAction);
        if (expired.get() == Boolean.TRUE) {
            return null;
        }
        return entry;
    }

    public static <K, V> MarshalledEntry<K, V> loadAndCheckExpiration(PersistenceManager persistenceManager, Object key, int segment, InvocationContext context) {
        return PersistenceUtil.loadAndCheckExpiration(persistenceManager, key, segment, context, true);
    }

    private static <K, V> MarshalledEntry<K, V> loadAndCheckExpiration(PersistenceManager persistenceManager, Object key, int segment, InvocationContext context, boolean includeStores) {
        MarshalledEntry loaded = segment != -1 ? persistenceManager.loadFromAllStores(key, segment, context.isOriginLocal(), includeStores) : persistenceManager.loadFromAllStores(key, context.isOriginLocal(), includeStores);
        if (trace) {
            log.tracef("Loaded %s for key %s from persistence.", (Object)loaded, key);
        }
        return loaded;
    }

    public static <K, V> InternalCacheEntry<K, V> convert(MarshalledEntry<K, V> loaded, InternalEntryFactory factory) {
        InternalMetadata metadata = loaded.getMetadata();
        if (metadata != null) {
            InternalMetadata actual = metadata instanceof InternalMetadataImpl ? ((InternalMetadataImpl)metadata).actual() : metadata;
            return factory.create(loaded.getKey(), loaded.getValue(), actual, metadata.created(), metadata.lifespan(), metadata.lastUsed(), metadata.maxIdle());
        }
        return factory.create(loaded.getKey(), loaded.getValue(), (Metadata)null);
    }

    public static <K> Predicate<? super K> combinePredicate(IntSet segments, KeyPartitioner keyPartitioner, Predicate<? super K> filter) {
        if (segments != null) {
            Predicate<Object> segmentFilter = k -> segments.contains(keyPartitioner.getSegment(k));
            return filter == null ? segmentFilter : filter.and(segmentFilter);
        }
        return filter;
    }

    public static <R> Flowable<R> parallelizePublisher(IntSet segments, Scheduler scheduler, IntFunction<Publisher<R>> publisherFunction) {
        Flowable flowable = new FlowableFromIntSetFunction<Publisher<R>>(segments, publisherFunction);
        flowable = flowable.filter(f -> f != Flowable.empty());
        return flowable.parallel().runOn(scheduler).flatMap(Functions.identity()).sequential();
    }
}

