/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.LongAdder;
import org.infinispan.commands.CancellableCommand;
import org.infinispan.commands.CancellationService;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.remoting.inboundhandler.DefaultTopologyRunnable;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.remoting.inboundhandler.action.ReadyAction;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;

@Scope(value=Scopes.NAMED_CACHE)
@MBean(objectName="InboundInvocationHandler", description="Handles all the remote requests.")
public abstract class BasePerCacheInboundInvocationHandler
implements PerCacheInboundInvocationHandler {
    public static final String MBEAN_COMPONENT_NAME = "InboundInvocationHandler";
    private static final int NO_TOPOLOGY_COMMAND = Integer.MIN_VALUE;
    @Inject
    @ComponentName(value="org.infinispan.executors.remote")
    protected BlockingTaskAwareExecutorService remoteCommandsExecutor;
    @Inject
    private StateTransferLock stateTransferLock;
    @Inject
    private ResponseGenerator responseGenerator;
    @Inject
    private CancellationService cancellationService;
    @Inject
    protected Configuration configuration;
    private volatile boolean stopped = false;
    private volatile int firstTopologyAsMember = Integer.MAX_VALUE;
    private final LongAdder syncXsiteReceived = new LongAdder();
    private final LongAdder asyncXsiteReceived = new LongAdder();
    private volatile boolean statisticsEnabled = false;

    private static int extractCommandTopologyId(SingleRpcCommand command) {
        ReplicableCommand innerCmd = command.getCommand();
        if (innerCmd instanceof TopologyAffectedCommand) {
            return ((TopologyAffectedCommand)innerCmd).getTopologyId();
        }
        return Integer.MIN_VALUE;
    }

    static int extractCommandTopologyId(CacheRpcCommand command) {
        switch (command.getCommandId()) {
            case 1: {
                return BasePerCacheInboundInvocationHandler.extractCommandTopologyId((SingleRpcCommand)command);
            }
            case 16: 
            case 46: {
                return Integer.MIN_VALUE;
            }
        }
        if (command instanceof TopologyAffectedCommand) {
            return ((TopologyAffectedCommand)((Object)command)).getTopologyId();
        }
        return Integer.MIN_VALUE;
    }

    @Start
    public void start() {
        this.stopped = false;
        this.setStatisticsEnabled(this.configuration.jmxStatistics().enabled());
    }

    @Stop
    public void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    final CompletableFuture<Response> invokeCommand(CacheRpcCommand cmd) throws Throwable {
        try {
            if (this.isTraceEnabled()) {
                this.getLog().tracef("Calling perform() on %s", (Object)cmd);
            }
            if (cmd instanceof CancellableCommand) {
                this.cancellationService.register(Thread.currentThread(), ((CancellableCommand)cmd).getUUID());
            }
            CompletableFuture<Object> future = cmd.invokeAsync();
            return future.handle((rv, throwable) -> {
                if (cmd instanceof CancellableCommand) {
                    this.cancellationService.unregister(((CancellableCommand)cmd).getUUID());
                }
                CompletableFutures.rethrowException(throwable);
                return this.responseGenerator.getResponse(cmd, rv);
            });
        }
        catch (Throwable throwable2) {
            if (cmd instanceof CancellableCommand) {
                this.cancellationService.unregister(((CancellableCommand)cmd).getUUID());
            }
            throw throwable2;
        }
    }

    final StateTransferLock getStateTransferLock() {
        return this.stateTransferLock;
    }

    final ExceptionResponse exceptionHandlingCommand(CacheRpcCommand command, Throwable throwable) {
        this.getLog().exceptionHandlingCommand(command, throwable);
        if (throwable instanceof Exception) {
            return new ExceptionResponse((Exception)throwable);
        }
        return new ExceptionResponse(new CacheException("Problems invoking command.", throwable));
    }

    final ExceptionResponse outdatedTopology(OutdatedTopologyException exception) {
        this.getLog().tracef("Topology changed, retrying: %s", (Object)exception);
        return new ExceptionResponse(exception);
    }

    final Response interruptedException(CacheRpcCommand command) {
        this.getLog().shutdownHandlingCommand(command);
        return CacheNotFoundResponse.INSTANCE;
    }

    final void unexpectedDeliverMode(ReplicableCommand command, DeliverOrder deliverOrder) {
        throw new IllegalArgumentException(String.format("Unexpected deliver mode %s for command%s", new Object[]{deliverOrder, command}));
    }

    final void handleRunnable(BlockingRunnable runnable, boolean onExecutorService) {
        if (onExecutorService) {
            this.remoteCommandsExecutor.execute(runnable);
        } else {
            runnable.run();
        }
    }

    public final boolean isCommandSentBeforeFirstTopology(int commandTopologyId) {
        if (0 <= commandTopologyId && commandTopologyId < this.firstTopologyAsMember) {
            if (this.isTraceEnabled()) {
                this.getLog().tracef("Ignoring command sent before the local node was a member (command topology id is %d, first topology as member is %d)", commandTopologyId, this.firstTopologyAsMember);
            }
            return true;
        }
        return false;
    }

    final BlockingRunnable createDefaultRunnable(CacheRpcCommand command, Reply reply, int commandTopologyId, boolean waitTransactionalData, boolean onExecutorService, boolean sync) {
        return new DefaultTopologyRunnable(this, command, reply, TopologyMode.create(onExecutorService, waitTransactionalData), commandTopologyId, sync);
    }

    final BlockingRunnable createDefaultRunnable(CacheRpcCommand command, Reply reply, int commandTopologyId, TopologyMode topologyMode, boolean sync) {
        return new DefaultTopologyRunnable(this, command, reply, topologyMode, commandTopologyId, sync);
    }

    protected abstract Log getLog();

    protected abstract boolean isTraceEnabled();

    final boolean executeOnExecutorService(DeliverOrder order, CacheRpcCommand command) {
        return !order.preserveOrder() && command.canBlock();
    }

    final BlockingRunnable createReadyActionRunnable(CacheRpcCommand command, Reply reply, int commandTopologyId, boolean sync, ReadyAction readyAction) {
        if (readyAction != null) {
            return this.createNonNullReadyActionRunnable(command, reply, commandTopologyId, sync, readyAction);
        }
        return new DefaultTopologyRunnable(this, command, reply, TopologyMode.READY_TX_DATA, commandTopologyId, sync);
    }

    @Override
    public void registerXSiteCommandReceiver(boolean sync) {
        if (this.statisticsEnabled) {
            (sync ? this.syncXsiteReceived : this.asyncXsiteReceived).increment();
        }
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.isStatisticsEnabled();
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.syncXsiteReceived.reset();
        this.asyncXsiteReceived.reset();
    }

    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @ManagedAttribute(description="Returns the number of sync cross-site requests received by this node", displayName="Sync Cross-Site Requests Received", units=Units.NONE, displayType=DisplayType.SUMMARY)
    public long getSyncXSiteRequestsReceived() {
        return this.statisticsEnabled ? this.syncXsiteReceived.sum() : 0L;
    }

    @ManagedAttribute(description="Returns the number of async cross-site requests received by this node", displayName="Async Cross-Site Requests Received", units=Units.NONE, displayType=DisplayType.SUMMARY)
    public long getAsyncXSiteRequestsReceived() {
        return this.statisticsEnabled ? this.asyncXsiteReceived.sum() : 0L;
    }

    private BlockingRunnable createNonNullReadyActionRunnable(CacheRpcCommand command, Reply reply, int commandTopologyId, boolean sync, final ReadyAction readyAction) {
        readyAction.addListener(this.remoteCommandsExecutor::checkForReadyTasks);
        return new DefaultTopologyRunnable(this, command, reply, TopologyMode.READY_TX_DATA, commandTopologyId, sync){

            @Override
            public boolean isReady() {
                return super.isReady() && readyAction.isReady();
            }

            @Override
            protected void onException(Throwable throwable) {
                super.onException(throwable);
                readyAction.onException();
            }

            @Override
            protected void onFinally() {
                super.onFinally();
                readyAction.onFinally();
            }
        };
    }

    @Override
    public void setFirstTopologyAsMember(int firstTopologyAsMember) {
        this.firstTopologyAsMember = firstTopologyAsMember;
    }

    @Override
    public int getFirstTopologyAsMember() {
        return this.firstTopologyAsMember;
    }
}

