/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.Request;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RequestRepository {
    private static final Log log = LogFactory.getLog(RequestRepository.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ConcurrentHashMap<Long, Request<?>> requests;
    private final AtomicLong nextRequestId = new AtomicLong(1L);

    public RequestRepository() {
        this.requests = new ConcurrentHashMap();
    }

    public long newRequestId() {
        long requestId = this.nextRequestId.getAndIncrement();
        if (requestId == 0L) {
            requestId = this.nextRequestId.getAndIncrement();
        }
        return requestId;
    }

    public void addRequest(Request<?> request) {
        long requestId = request.getRequestId();
        Request<?> existingRequest = this.requests.putIfAbsent(requestId, request);
        if (existingRequest != null) {
            throw new IllegalStateException("Duplicate request id " + requestId);
        }
    }

    public void addResponse(long requestId, Address sender, Response response) {
        Request<?> request = this.requests.get(requestId);
        if (request == null) {
            if (trace) {
                log.tracef("Ignoring response for non-existent request %d from %s: %s", requestId, (Object)sender, (Object)response);
            }
            return;
        }
        request.onResponse(sender, response);
    }

    public void removeRequest(long requestId) {
        this.requests.remove(requestId);
    }

    public void forEach(Consumer<Request<?>> consumer) {
        this.requests.forEach((? super K id, ? super V request) -> consumer.accept((Request<?>)request));
    }
}

