/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.CloseableIterable;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class PriorityMergingProcessor<T>
implements CloseableIterable<T> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final PublisherIntPair<T> firstPair;
    private final Collection<PublisherIntPair<T>> pairs;

    public static <T> PriorityMergingProcessor<T> build(Publisher<T> publisher, int firstbatchSize, Publisher<T> secondPublisher, int secondBatchSize) {
        return new PriorityMergingProcessor<T>(publisher, firstbatchSize, secondPublisher, secondBatchSize);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private PriorityMergingProcessor(Publisher<T> publisher, int firstbatchSize, Publisher<T> secondPublisher, int secondBatchSize) {
        this.firstPair = new PublisherIntPair(publisher, firstbatchSize);
        this.pairs = Collections.singleton(new PublisherIntPair(secondPublisher, secondBatchSize));
    }

    private PriorityMergingProcessor(PublisherIntPair<T> firstPair, Collection<PublisherIntPair<T>> pairs) {
        this.firstPair = firstPair;
        this.pairs = pairs;
    }

    @Override
    public void close() {
    }

    @Override
    public CloseableIterator<T> iterator() {
        MultiSubscriberIterator<T> iterator = new MultiSubscriberIterator<T>(this.firstPair, this.pairs);
        iterator.start();
        return iterator;
    }

    static /* synthetic */ Log access$400() {
        return log;
    }

    private static final class QueueSubscriber<T>
    extends AtomicReference<Subscription>
    implements Subscriber<T>,
    AutoCloseable {
        private final Publisher<T> publisher;
        private final SimplePlainQueue<T> queue;
        private final long batchSize;
        private final long limit;
        private MultiSubscriberIterator notifier;
        private long produced;
        private volatile boolean done;

        QueueSubscriber(Publisher<T> publisher, int batchSize, MultiSubscriberIterator subscriber) {
            this.publisher = publisher;
            this.queue = new SpscArrayQueue<T>(batchSize);
            this.batchSize = batchSize;
            this.notifier = subscriber;
            this.limit = batchSize - (batchSize >> 2);
        }

        void start() {
            this.publisher.subscribe(this);
        }

        public T poll() {
            T returned = this.queue.poll();
            if (returned != null) {
                long p = this.produced + 1L;
                if (p == this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p);
                } else {
                    this.produced = p;
                }
            }
            return returned;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this, s)) {
                s.request(this.batchSize);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.queue.offer(t)) {
                SubscriptionHelper.cancel(this);
                this.onError(new IllegalStateException("Too many items requested, this is a bug! - produced=" + this.produced + ", subscription=" + this.get()));
            } else {
                this.notifier.signalConsumer();
            }
        }

        @Override
        public void onError(Throwable t) {
            this.done = true;
            this.notifier.onError(t);
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.notifier.signalConsumer();
        }

        @Override
        public void close() {
            SubscriptionHelper.cancel(this);
        }

        public boolean isDone() {
            return this.done;
        }

        @Override
        public String toString() {
            return "QueueSubscriber{queue.empty = " + this.queue.isEmpty() + ", done = " + this.done + "}";
        }
    }

    private static final class MultiSubscriberIterator<T>
    extends AbstractIterator<T>
    implements CloseableIterator<T> {
        private final QueueSubscriber<T> firstQueueSubscriber;
        private final QueueSubscriber<T>[] queueSubscribers;
        private final Lock lock;
        private final Condition condition;
        private boolean signalled;
        volatile Throwable error;

        MultiSubscriberIterator(PublisherIntPair<T> firstPair, Collection<PublisherIntPair<T>> pairs) {
            this.firstQueueSubscriber = new QueueSubscriber(((PublisherIntPair)firstPair).publisher, ((PublisherIntPair)firstPair).batchSize, this);
            this.queueSubscribers = new QueueSubscriber[pairs.size()];
            this.signalled = false;
            this.lock = new ReentrantLock();
            this.condition = this.lock.newCondition();
            int offset = 0;
            for (PublisherIntPair<T> pair : pairs) {
                QueueSubscriber actualSubscriber = new QueueSubscriber(((PublisherIntPair)pair).publisher, ((PublisherIntPair)pair).batchSize, this);
                this.queueSubscribers[offset++] = actualSubscriber;
            }
        }

        public void start() {
            this.firstQueueSubscriber.start();
            for (QueueSubscriber<T> queueSubscriber : this.queueSubscribers) {
                queueSubscriber.start();
            }
        }

        static RuntimeException wrapOrThrow(Throwable error) {
            if (!(error instanceof CacheException)) {
                return new CacheException(error);
            }
            return (CacheException)error;
        }

        @Override
        public void close() {
            this.firstQueueSubscriber.close();
            for (QueueSubscriber<T> queueSubscriber : this.queueSubscribers) {
                queueSubscriber.close();
            }
            this.signalConsumer();
        }

        /*
         * Exception decompiling
         */
        @Override
        protected T getNext() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        void onError(Throwable t) {
            this.error = t;
            this.signalConsumer();
        }

        void signalConsumer() {
            this.lock.lock();
            try {
                if (!this.signalled) {
                    this.signalled = true;
                    this.condition.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static class Builder<T> {
        PublisherIntPair<T> firstPair;
        Stream.Builder<PublisherIntPair<T>> current = Stream.builder();

        Builder<T> addPublisher(Publisher<T> publisher, int batchSize) {
            if (this.firstPair == null) {
                this.firstPair = new PublisherIntPair(publisher, batchSize);
            } else {
                this.current.accept(new PublisherIntPair(publisher, batchSize));
            }
            return this;
        }

        PriorityMergingProcessor<T> build() {
            return new PriorityMergingProcessor(this.firstPair, this.current.build().collect(Collectors.toList()));
        }
    }

    private static class PublisherIntPair<T> {
        private final Publisher<T> publisher;
        private final int batchSize;

        private PublisherIntPair(Publisher<T> publisher, int batchSize) {
            this.publisher = Objects.requireNonNull(publisher);
            if (batchSize <= 0) {
                throw new IllegalArgumentException("batchSize must be greater than 0");
            }
            this.batchSize = batchSize;
        }
    }
}

