/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.stream.impl.LocalStreamManager;
import org.infinispan.util.ByteString;

public class StreamIteratorNextCommand
extends BaseRpcCommand
implements TopologyAffectedCommand {
    public static final byte COMMAND_ID = 71;
    @Inject
    protected LocalStreamManager lsm;
    protected Object id;
    protected long batchSize;
    protected int topologyId = -1;

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    public Object getId() {
        return this.id;
    }

    private StreamIteratorNextCommand() {
        super(null);
    }

    public StreamIteratorNextCommand(ByteString cacheName) {
        super(cacheName);
    }

    public StreamIteratorNextCommand(ByteString cacheName, Object id, long batchSize) {
        super(cacheName);
        this.id = id;
        this.batchSize = batchSize;
    }

    public void inject(LocalStreamManager lsm) {
        this.lsm = lsm;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        return CompletableFuture.completedFuture(this.lsm.continueIterator(this.id, this.batchSize));
    }

    @Override
    public byte getCommandId() {
        return 71;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.id);
        UnsignedNumeric.writeUnsignedLong(output, this.batchSize);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.id = input.readObject();
        this.batchSize = UnsignedNumeric.readUnsignedLong(input);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return true;
    }
}

