/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.StreamIteratorNextCommand;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.util.ByteString;

public class StreamIteratorRequestCommand<K>
extends StreamIteratorNextCommand {
    public static final byte COMMAND_ID = 70;
    private boolean parallelStream;
    private IntSet segments;
    private Set<K> keys;
    private Set<K> excludedKeys;
    private boolean includeLoader;
    private boolean entryStream;
    private Iterable<IntermediateOperation> intOps;

    private StreamIteratorRequestCommand() {
        super(null);
    }

    public StreamIteratorRequestCommand(ByteString cacheName) {
        super(cacheName);
    }

    public StreamIteratorRequestCommand(ByteString cacheName, Address origin, Object id, boolean parallelStream, IntSet segments, Set<K> keys, Set<K> excludedKeys, boolean includeLoader, boolean entryStream, Iterable<IntermediateOperation> intOps, long batchSize) {
        super(cacheName, id, batchSize);
        this.setOrigin(origin);
        this.parallelStream = parallelStream;
        this.segments = segments;
        this.keys = keys;
        this.excludedKeys = excludedKeys;
        this.includeLoader = includeLoader;
        this.entryStream = entryStream;
        this.intOps = intOps;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        return CompletableFuture.completedFuture(this.lsm.startIterator(this.id, this.getOrigin(), this.segments, this.keys, this.excludedKeys, this.includeLoader, this.entryStream, this.intOps, this.batchSize));
    }

    @Override
    public byte getCommandId() {
        return 70;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        output.writeObject(this.getOrigin());
        output.writeBoolean(this.parallelStream);
        output.writeObject(this.segments);
        MarshallUtil.marshallCollection(this.keys, output);
        MarshallUtil.marshallCollection(this.excludedKeys, output);
        output.writeBoolean(this.includeLoader);
        output.writeBoolean(this.entryStream);
        output.writeObject(this.intOps);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        this.setOrigin((Address)input.readObject());
        this.parallelStream = input.readBoolean();
        this.segments = (IntSet)input.readObject();
        this.keys = MarshallUtil.unmarshallCollectionUnbounded(input, HashSet::new);
        this.excludedKeys = MarshallUtil.unmarshallCollectionUnbounded(input, HashSet::new);
        this.includeLoader = input.readBoolean();
        this.entryStream = input.readBoolean();
        this.intOps = (Iterable)input.readObject();
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return true;
    }
}

