/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SegmentedKeyStreamSupplier<K, V>
implements AbstractLocalCacheStream.StreamSupplier<K, Stream<K>> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    private final Cache<K, V> cache;
    private final ToIntFunction<Object> toIntFunction;
    private final InternalDataContainer<K, V> internalDataContainer;

    public SegmentedKeyStreamSupplier(Cache<K, V> cache, ToIntFunction<Object> toIntFunction, InternalDataContainer<K, V> internalDataContainer) {
        this.cache = cache;
        this.toIntFunction = toIntFunction;
        this.internalDataContainer = internalDataContainer;
    }

    @Override
    public Stream<K> buildStream(IntSet segmentsToFilter, Set<?> keysToFilter, boolean parallel) {
        Stream<Object> stream;
        if (keysToFilter != null) {
            if (trace) {
                log.tracef("Applying key filtering %s", (Object)keysToFilter);
            }
            AdvancedCache<K, V> advancedCache = AbstractDelegatingCache.unwrapCache(this.cache).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL);
            stream = (parallel ? keysToFilter.parallelStream() : keysToFilter.stream()).filter(advancedCache::containsKey);
            if (segmentsToFilter != null && this.toIntFunction != null) {
                if (trace) {
                    log.tracef("Applying segment filter %s", (Object)segmentsToFilter);
                }
                stream = stream.filter(k -> {
                    int segment = this.toIntFunction.applyAsInt(k);
                    boolean isPresent = segmentsToFilter.contains(segment);
                    if (trace) {
                        log.tracef("Is key %s present in segment %d? %b", k, (Object)segment, (Object)isPresent);
                    }
                    return isPresent;
                });
            }
        } else {
            Stream entryStream = segmentsToFilter != null ? StreamSupport.stream(this.internalDataContainer.spliterator(segmentsToFilter), parallel) : StreamSupport.stream(this.internalDataContainer.spliterator(), parallel);
            if (this.cache.getCacheConfiguration().clustering().cacheMode().isScattered()) {
                entryStream = entryStream.filter(ce -> ce.getValue() != null);
            }
            stream = entryStream.map(CacheEntry::getKey);
        }
        return stream;
    }
}

