/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.infinispan.commons.util.ByRef;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.BaseTerminalOperation;

public abstract class AbstractForEachOperation<Original, K, V, S extends BaseStream<V, S>>
extends BaseTerminalOperation<Original>
implements KeyTrackingTerminalOperation<Original, K, V> {
    private final int batchSize;
    private final Function<? super Original, ? extends K> toKeyFunction;

    public AbstractForEachOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<Original>> supplier, Function<? super Original, ? extends K> toKeyFunction, int batchSize) {
        super(intermediateOperations, supplier);
        this.batchSize = batchSize;
        this.toKeyFunction = toKeyFunction;
    }

    @Override
    public boolean lostSegment(boolean stopIfLost) {
        return true;
    }

    @Override
    public List<V> performOperation(KeyTrackingTerminalOperation.IntermediateCollector<Collection<V>> response) {
        throw new UnsupportedOperationException();
    }

    protected abstract void handleList(List<V> var1);

    protected abstract void handleStreamForEach(S var1, List<V> var2);

    @Override
    public Collection<K> performForEachOperation(KeyTrackingTerminalOperation.IntermediateCollector<Collection<K>> response) {
        Stream<Object> originalStream = (Stream<Object>)((Stream)this.supplier.get()).sequential();
        ArrayList<Object> collectedValues = new ArrayList<Object>(this.batchSize);
        ArrayList currentList = new ArrayList();
        ByRef<Object> currentKey = new ByRef<Object>(null);
        Stream<Object> stream = originalStream = originalStream.peek(e -> {
            if (!currentList.isEmpty()) {
                collectedValues.add(currentKey.get());
                if (collectedValues.size() >= this.batchSize) {
                    this.handleList(currentList);
                    response.sendDataResonse(collectedValues);
                    collectedValues.clear();
                    currentList.clear();
                }
            }
            currentKey.set(this.toKeyFunction.apply(e));
        });
        for (IntermediateOperation intermediateOperation : this.intermediateOperations) {
            stream = intermediateOperation.perform(stream);
        }
        Stream<Object> convertedStream = stream;
        this.handleStreamForEach(convertedStream, currentList);
        if (!currentList.isEmpty()) {
            this.handleList(currentList);
            collectedValues.add(currentKey.get());
        }
        return collectedValues;
    }

    public Function<? super Original, ? extends K> getToKeyFunction() {
        return this.toKeyFunction;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

