/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheTopology {
    private static Log log = LogFactory.getLog(CacheTopology.class);
    private static final boolean trace = log.isTraceEnabled();
    private final int topologyId;
    private final int rebalanceId;
    private final ConsistentHash currentCH;
    private final ConsistentHash pendingCH;
    private final ConsistentHash unionCH;
    private final Phase phase;
    private List<Address> actualMembers;
    private List<PersistentUUID> persistentUUIDs;

    public CacheTopology(int topologyId, int rebalanceId, ConsistentHash currentCH, ConsistentHash pendingCH, Phase phase, List<Address> actualMembers, List<PersistentUUID> persistentUUIDs) {
        this(topologyId, rebalanceId, currentCH, pendingCH, null, phase, actualMembers, persistentUUIDs);
    }

    public CacheTopology(int topologyId, int rebalanceId, ConsistentHash currentCH, ConsistentHash pendingCH, ConsistentHash unionCH, Phase phase, List<Address> actualMembers, List<PersistentUUID> persistentUUIDs) {
        if (pendingCH != null && !pendingCH.getMembers().containsAll(currentCH.getMembers())) {
            throw new IllegalArgumentException("A cache topology's pending consistent hash must contain all the current consistent hash's members: currentCH=" + currentCH + ", pendingCH=" + pendingCH);
        }
        if (persistentUUIDs != null && persistentUUIDs.size() != actualMembers.size()) {
            throw new IllegalArgumentException("There must be one persistent UUID for each actual member");
        }
        this.topologyId = topologyId;
        this.rebalanceId = rebalanceId;
        this.currentCH = currentCH;
        this.pendingCH = pendingCH;
        this.unionCH = unionCH;
        this.phase = phase;
        this.actualMembers = actualMembers;
        this.persistentUUIDs = persistentUUIDs;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public ConsistentHash getCurrentCH() {
        return this.currentCH;
    }

    public ConsistentHash getPendingCH() {
        return this.pendingCH;
    }

    public ConsistentHash getUnionCH() {
        return this.unionCH;
    }

    public int getRebalanceId() {
        return this.rebalanceId;
    }

    public List<Address> getMembers() {
        if (this.pendingCH != null) {
            return this.pendingCH.getMembers();
        }
        if (this.currentCH != null) {
            return this.currentCH.getMembers();
        }
        return Collections.emptyList();
    }

    public List<Address> getActualMembers() {
        return this.actualMembers;
    }

    public List<PersistentUUID> getMembersPersistentUUIDs() {
        return this.persistentUUIDs;
    }

    public ConsistentHash getReadConsistentHash() {
        switch (this.phase) {
            case CONFLICT_RESOLUTION: 
            case NO_REBALANCE: {
                assert (this.pendingCH == null);
                assert (this.unionCH == null);
                return this.currentCH;
            }
            case TRANSITORY: {
                return this.pendingCH;
            }
            case READ_OLD_WRITE_ALL: {
                assert (this.pendingCH != null);
                assert (this.unionCH != null);
                return this.currentCH;
            }
            case READ_ALL_WRITE_ALL: {
                assert (this.pendingCH != null);
                return this.unionCH;
            }
            case READ_NEW_WRITE_ALL: {
                assert (this.unionCH != null);
                return this.pendingCH;
            }
        }
        throw new IllegalStateException();
    }

    public ConsistentHash getWriteConsistentHash() {
        switch (this.phase) {
            case CONFLICT_RESOLUTION: 
            case NO_REBALANCE: {
                assert (this.pendingCH == null);
                assert (this.unionCH == null);
                return this.currentCH;
            }
            case TRANSITORY: {
                return this.pendingCH;
            }
            case READ_OLD_WRITE_ALL: 
            case READ_ALL_WRITE_ALL: 
            case READ_NEW_WRITE_ALL: {
                assert (this.pendingCH != null);
                assert (this.unionCH != null);
                return this.unionCH;
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheTopology that = (CacheTopology)o;
        if (this.topologyId != that.topologyId) {
            return false;
        }
        if (this.rebalanceId != that.rebalanceId) {
            return false;
        }
        if (this.phase != that.phase) {
            return false;
        }
        if (this.currentCH != null ? !this.currentCH.equals(that.currentCH) : that.currentCH != null) {
            return false;
        }
        if (this.pendingCH != null ? !this.pendingCH.equals(that.pendingCH) : that.pendingCH != null) {
            return false;
        }
        if (this.unionCH != null ? !this.unionCH.equals(that.unionCH) : that.unionCH != null) {
            return false;
        }
        return !(this.actualMembers != null ? !this.actualMembers.equals(that.actualMembers) : that.actualMembers != null);
    }

    public int hashCode() {
        int result = this.topologyId;
        result = 31 * result + this.rebalanceId;
        result = 31 * result + (this.phase != null ? this.phase.hashCode() : 0);
        result = 31 * result + (this.currentCH != null ? this.currentCH.hashCode() : 0);
        result = 31 * result + (this.pendingCH != null ? this.pendingCH.hashCode() : 0);
        result = 31 * result + (this.unionCH != null ? this.unionCH.hashCode() : 0);
        result = 31 * result + (this.actualMembers != null ? this.actualMembers.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CacheTopology{id=" + this.topologyId + ", phase=" + (Object)((Object)this.phase) + ", rebalanceId=" + this.rebalanceId + ", currentCH=" + this.currentCH + ", pendingCH=" + this.pendingCH + ", unionCH=" + this.unionCH + ", actualMembers=" + this.actualMembers + ", persistentUUIDs=" + this.persistentUUIDs + '}';
    }

    public final void logRoutingTableInformation() {
        if (trace) {
            log.tracef("Current consistent hash's routing table: %s", (Object)this.currentCH.getRoutingTableAsString());
            if (this.pendingCH != null) {
                log.tracef("Pending consistent hash's routing table: %s", (Object)this.pendingCH.getRoutingTableAsString());
            }
            if (this.unionCH != null) {
                log.tracef("Union consistent hash's routing table: %s", (Object)this.unionCH.getRoutingTableAsString());
            }
        }
    }

    public Phase getPhase() {
        return this.phase;
    }

    public static enum Phase {
        NO_REBALANCE(false),
        TRANSITORY(true),
        CONFLICT_RESOLUTION(false),
        READ_OLD_WRITE_ALL(true),
        READ_ALL_WRITE_ALL(false),
        READ_NEW_WRITE_ALL(false);

        private static final Phase[] values;
        private final boolean rebalance;

        private Phase(boolean rebalance) {
            this.rebalance = rebalance;
        }

        public boolean isRebalance() {
            return this.rebalance;
        }

        public static Phase valueOf(int ordinal) {
            return values[ordinal];
        }

        static {
            values = Phase.values();
        }
    }

    public static class Externalizer
    extends InstanceReusingAdvancedExternalizer<CacheTopology> {
        @Override
        public void doWriteObject(ObjectOutput output, CacheTopology cacheTopology) throws IOException {
            output.writeInt(cacheTopology.topologyId);
            output.writeInt(cacheTopology.rebalanceId);
            output.writeObject(cacheTopology.currentCH);
            output.writeObject(cacheTopology.pendingCH);
            output.writeObject(cacheTopology.unionCH);
            output.writeObject(cacheTopology.actualMembers);
            output.writeObject(cacheTopology.persistentUUIDs);
            MarshallUtil.marshallEnum(cacheTopology.phase, output);
        }

        @Override
        public CacheTopology doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            int topologyId = unmarshaller.readInt();
            int rebalanceId = unmarshaller.readInt();
            ConsistentHash currentCH = (ConsistentHash)unmarshaller.readObject();
            ConsistentHash pendingCH = (ConsistentHash)unmarshaller.readObject();
            ConsistentHash unionCH = (ConsistentHash)unmarshaller.readObject();
            List actualMembers = (List)unmarshaller.readObject();
            List persistentUUIDs = (List)unmarshaller.readObject();
            Phase phase = MarshallUtil.unmarshallEnum(unmarshaller, Phase::valueOf);
            return new CacheTopology(topologyId, rebalanceId, currentCH, pendingCH, unionCH, phase, actualMembers, persistentUUIDs);
        }

        @Override
        public Integer getId() {
            return 37;
        }

        @Override
        public Set<Class<? extends CacheTopology>> getTypeClasses() {
            return Collections.singleton(CacheTopology.class);
        }
    }
}

