/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonValueReader;
import com.squareup.moshi.JsonValueWriter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public abstract class JsonAdapter<T> {
    public abstract T fromJson(JsonReader var1) throws IOException;

    public final T fromJson(BufferedSource source) throws IOException {
        return this.fromJson(JsonReader.of(source));
    }

    public final T fromJson(String string) throws IOException {
        return this.fromJson(new Buffer().writeUtf8(string));
    }

    public abstract void toJson(JsonWriter var1, T var2) throws IOException;

    public final void toJson(BufferedSink sink, T value) throws IOException {
        JsonWriter writer = JsonWriter.of(sink);
        this.toJson(writer, value);
    }

    public final String toJson(T value) {
        Buffer buffer = new Buffer();
        try {
            this.toJson(buffer, value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return buffer.readUtf8();
    }

    public final Object toJsonValue(T value) {
        JsonValueWriter writer = new JsonValueWriter();
        try {
            this.toJson(writer, value);
            return writer.root();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final T fromJsonValue(Object value) {
        JsonValueReader reader = new JsonValueReader(value);
        try {
            return this.fromJson(reader);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final JsonAdapter<T> serializeNulls() {
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            @Override
            public T fromJson(JsonReader reader) throws IOException {
                return delegate.fromJson(reader);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toJson(JsonWriter writer, T value) throws IOException {
                boolean serializeNulls = writer.getSerializeNulls();
                writer.setSerializeNulls(true);
                try {
                    delegate.toJson(writer, value);
                }
                finally {
                    writer.setSerializeNulls(serializeNulls);
                }
            }

            public String toString() {
                return delegate + ".serializeNulls()";
            }
        };
    }

    public final JsonAdapter<T> nullSafe() {
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            @Override
            public T fromJson(JsonReader reader) throws IOException {
                if (reader.peek() == JsonReader.Token.NULL) {
                    return reader.nextNull();
                }
                return delegate.fromJson(reader);
            }

            @Override
            public void toJson(JsonWriter writer, T value) throws IOException {
                if (value == null) {
                    writer.nullValue();
                } else {
                    delegate.toJson(writer, value);
                }
            }

            public String toString() {
                return delegate + ".nullSafe()";
            }
        };
    }

    public final JsonAdapter<T> lenient() {
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T fromJson(JsonReader reader) throws IOException {
                boolean lenient = reader.isLenient();
                reader.setLenient(true);
                try {
                    Object t = delegate.fromJson(reader);
                    return t;
                }
                finally {
                    reader.setLenient(lenient);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toJson(JsonWriter writer, T value) throws IOException {
                boolean lenient = writer.isLenient();
                writer.setLenient(true);
                try {
                    delegate.toJson(writer, value);
                }
                finally {
                    writer.setLenient(lenient);
                }
            }

            public String toString() {
                return delegate + ".lenient()";
            }
        };
    }

    public final JsonAdapter<T> failOnUnknown() {
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T fromJson(JsonReader reader) throws IOException {
                boolean skipForbidden = reader.failOnUnknown();
                reader.setFailOnUnknown(true);
                try {
                    Object t = delegate.fromJson(reader);
                    return t;
                }
                finally {
                    reader.setFailOnUnknown(skipForbidden);
                }
            }

            @Override
            public void toJson(JsonWriter writer, T value) throws IOException {
                delegate.toJson(writer, value);
            }

            public String toString() {
                return delegate + ".failOnUnknown()";
            }
        };
    }

    public JsonAdapter<T> indent(final String indent) {
        final JsonAdapter delegate = this;
        return new JsonAdapter<T>(){

            @Override
            public T fromJson(JsonReader reader) throws IOException {
                return delegate.fromJson(reader);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toJson(JsonWriter writer, T value) throws IOException {
                String originalIndent = writer.getIndent();
                writer.setIndent(indent);
                try {
                    delegate.toJson(writer, value);
                }
                finally {
                    writer.setIndent(originalIndent);
                }
            }

            public String toString() {
                return delegate + ".indent(\"" + indent + "\")";
            }
        };
    }

    public static interface Factory {
        public JsonAdapter<?> create(Type var1, Set<? extends Annotation> var2, Moshi var3);
    }
}

