/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.influxdb.InfluxDbComponent;
import org.apache.camel.component.influxdb.InfluxDbConstants;
import org.apache.camel.component.influxdb.InfluxDbProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.18.0", scheme="influxdb", title="InfluxDB", syntax="influxdb:connectionBean", category={Category.DATABASE}, producerOnly=true, headersClass=InfluxDbConstants.class)
public class InfluxDbEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDbEndpoint.class);
    private static final String CREATE_DATABASE = "CREATE DATABASE ";
    private static final String SHOW_DATABASES = "SHOW DATABASES";
    private InfluxDB influxDB;
    @UriPath
    @Metadata(required=true)
    private String connectionBean;
    @UriParam
    private String databaseName;
    @UriParam(defaultValue="default")
    private String retentionPolicy = "default";
    @UriParam(defaultValue="false")
    private boolean batch;
    @UriParam(defaultValue="insert")
    private String operation = "insert";
    @UriParam
    private String query;
    @UriParam(defaultValue="false")
    private boolean checkDatabaseExistence;
    @UriParam(defaultValue="false")
    private boolean autoCreateDatabase;

    public InfluxDbEndpoint(String uri, InfluxDbComponent component) {
        super(uri, component);
    }

    @Override
    public Producer createProducer() throws Exception {
        return new InfluxDbProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        if (this.checkDatabaseExistence) {
            this.ensureDatabaseExists();
        }
    }

    public InfluxDB getInfluxDB() {
        return this.influxDB;
    }

    public void setInfluxDB(InfluxDB influxDB) {
        this.influxDB = influxDB;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public void setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public String getConnectionBean() {
        return this.connectionBean;
    }

    public void setConnectionBean(String connectionBean) {
        this.connectionBean = connectionBean;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isCheckDatabaseExistence() {
        return this.checkDatabaseExistence;
    }

    public void setCheckDatabaseExistence(boolean checkDatabaseExistence) {
        this.checkDatabaseExistence = checkDatabaseExistence;
    }

    public boolean isAutoCreateDatabase() {
        return this.autoCreateDatabase;
    }

    public void setAutoCreateDatabase(boolean autoCreateDatabase) {
        this.autoCreateDatabase = autoCreateDatabase;
    }

    private void ensureDatabaseExists() {
        boolean exists;
        QueryResult result = this.getInfluxDB().query(new Query(SHOW_DATABASES));
        try {
            exists = result.getResults().get(0).getSeries().get(0).getValues().get(0).contains(this.databaseName);
        }
        catch (NullPointerException e) {
            exists = false;
        }
        if (!exists && this.autoCreateDatabase) {
            LOG.debug("Database {} doesn't exist. Creating it...", (Object)this.databaseName);
            this.getInfluxDB().query(new Query(CREATE_DATABASE + this.databaseName, ""));
        }
    }
}

