/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb;

import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.influxdb.CamelInfluxDbException;
import org.apache.camel.component.influxdb.InfluxDbEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.influxdb.InfluxDB;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDbProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDbProducer.class);
    InfluxDbEndpoint endpoint;
    InfluxDB connection;

    public InfluxDbProducer(InfluxDbEndpoint endpoint) {
        super(endpoint);
        this.connection = endpoint.getInfluxDB();
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String dataBaseName = this.calculateDatabaseName(exchange);
        String retentionPolicy = this.calculateRetentionPolicy(exchange);
        switch (this.endpoint.getOperation()) {
            case "insert": {
                this.doInsert(exchange, dataBaseName, retentionPolicy);
                break;
            }
            case "query": {
                this.doQuery(exchange, dataBaseName);
                break;
            }
            case "ping": {
                this.doPing(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("The operation " + this.endpoint.getOperation() + " is not supported");
            }
        }
    }

    private void doInsert(Exchange exchange, String dataBaseName, String retentionPolicy) throws InvalidPayloadException {
        if (!this.endpoint.isBatch()) {
            Point p = exchange.getIn().getMandatoryBody(Point.class);
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Writing point {}", (Object)p.lineProtocol());
                }
                this.connection.write(dataBaseName, retentionPolicy, p);
            }
            catch (Exception ex) {
                exchange.setException(new CamelInfluxDbException(ex));
            }
        } else {
            BatchPoints batchPoints = exchange.getIn().getMandatoryBody(BatchPoints.class);
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Writing BatchPoints {}", (Object)batchPoints.lineProtocol());
                }
                this.connection.write(batchPoints);
            }
            catch (Exception ex) {
                exchange.setException(new CamelInfluxDbException(ex));
            }
        }
    }

    private void doQuery(Exchange exchange, String dataBaseName) {
        String query = this.calculateQuery(exchange);
        Query influxdbQuery = new Query(query, dataBaseName);
        QueryResult resultSet = this.connection.query(influxdbQuery);
        MessageHelper.copyHeaders(exchange.getIn(), exchange.getOut(), true);
        exchange.getMessage().setBody(resultSet);
    }

    private void doPing(Exchange exchange) {
        Pong result = this.connection.ping();
        MessageHelper.copyHeaders(exchange.getIn(), exchange.getOut(), true);
        exchange.getMessage().setBody(result);
    }

    private String calculateRetentionPolicy(Exchange exchange) {
        String retentionPolicy = exchange.getIn().getHeader("camelInfluxDB.RetentionPolicy", String.class);
        if (ObjectHelper.isNotEmpty(retentionPolicy)) {
            return retentionPolicy;
        }
        return this.endpoint.getRetentionPolicy();
    }

    private String calculateDatabaseName(Exchange exchange) {
        String dbName = exchange.getIn().getHeader("camelInfluxDB.databaseName", String.class);
        if (ObjectHelper.isNotEmpty(dbName)) {
            return dbName;
        }
        return this.endpoint.getDatabaseName();
    }

    private String calculateQuery(Exchange exchange) {
        String query = exchange.getIn().getHeader("camelInfluxDB.query", String.class);
        if (ObjectHelper.isNotEmpty(query)) {
            return query;
        }
        query = this.endpoint.getQuery();
        if (ObjectHelper.isEmpty(query)) {
            throw new IllegalArgumentException("The query option must be set if you want to run a query operation");
        }
        return query;
    }
}

