/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb.converters;

import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.component.influxdb.CamelInfluxDbException;
import org.influxdb.dto.Point;

@Converter(generateLoader=true)
public final class CamelInfluxDbConverters {
    private CamelInfluxDbConverters() {
    }

    @Converter
    public static Point fromMapToPoint(Map<String, Object> map) {
        Object measurementName = map.get("camelInfluxDB.MeasurementName");
        if (measurementName == null) {
            String format = String.format("Unable to find the header for the measurement in: %s", map.keySet().toString());
            throw new CamelInfluxDbException(format);
        }
        String measurenmentNameString = measurementName.toString();
        Point.Builder pointBuilder = Point.measurement(measurenmentNameString);
        map.remove("camelInfluxDB.MeasurementName");
        pointBuilder.fields(map);
        map.put("camelInfluxDB.MeasurementName", measurementName);
        return pointBuilder.build();
    }
}

