/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducer;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.service.ServiceHelper;

public final class AsyncProcessorConverterHelper {
    private AsyncProcessorConverterHelper() {
    }

    public static AsyncProducer convert(Producer value) {
        if (value instanceof AsyncProducer) {
            return (AsyncProducer)value;
        }
        return new ProducerToAsyncProducerBridge(value);
    }

    public static AsyncProcessor convert(Processor value) {
        if (value instanceof AsyncProcessor) {
            return (AsyncProcessor)value;
        }
        return new ProcessorToAsyncProcessorBridge(value);
    }

    private static class ProducerToAsyncProducerBridge
    extends ProcessorToAsyncProcessorBridge
    implements AsyncProducer {
        ProducerToAsyncProducerBridge(Producer producer) {
            super(producer);
        }

        protected Producer producer() {
            return (Producer)this.processor;
        }

        @Override
        public Endpoint getEndpoint() {
            return this.producer().getEndpoint();
        }

        @Override
        public boolean isSingleton() {
            return this.producer().isSingleton();
        }
    }

    private static class ProcessorToAsyncProcessorBridge
    implements DelegateProcessor,
    AsyncProcessor,
    Navigate<Processor>,
    Service {
        protected final Processor processor;

        private ProcessorToAsyncProcessorBridge(Processor processor) {
            this.processor = processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean process(Exchange exchange, AsyncCallback callback) {
            if (this.processor == null) {
                callback.done(true);
                return true;
            }
            try {
                this.processor.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            finally {
                callback.done(true);
            }
            return true;
        }

        @Override
        public CompletableFuture<Exchange> processAsync(Exchange exchange) {
            AsyncCallbackToCompletableFutureAdapter<Exchange> callback = new AsyncCallbackToCompletableFutureAdapter<Exchange>(exchange);
            this.process(exchange, callback);
            return callback.getFuture();
        }

        public String toString() {
            if (this.processor != null) {
                return this.processor.toString();
            }
            return "Processor is null";
        }

        @Override
        public void process(Exchange exchange) throws Exception {
            this.processNext(exchange);
        }

        protected void processNext(Exchange exchange) throws Exception {
            if (this.processor != null) {
                this.processor.process(exchange);
            }
        }

        @Override
        public void build() {
            ServiceHelper.buildService((Object)this.processor);
        }

        @Override
        public void init() {
            ServiceHelper.initService((Object)this.processor);
        }

        @Override
        public void start() {
            ServiceHelper.startService((Object)this.processor);
        }

        @Override
        public void stop() {
            ServiceHelper.stopService((Object)this.processor);
        }

        @Override
        public boolean hasNext() {
            return this.processor != null;
        }

        @Override
        public List<Processor> next() {
            if (!this.hasNext()) {
                return null;
            }
            ArrayList<Processor> answer = new ArrayList<Processor>(1);
            answer.add(this.processor);
            return answer;
        }

        @Override
        public Processor getProcessor() {
            return this.processor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (this.processor == null) {
                return false;
            }
            ProcessorToAsyncProcessorBridge that = (ProcessorToAsyncProcessorBridge)o;
            return this.processor.equals(that.processor);
        }

        public int hashCode() {
            if (this.processor != null) {
                return this.processor.hashCode();
            }
            return 0;
        }
    }
}

