/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.PriorityQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public class AsyncCompletionService<V> {
    private final Executor executor;
    private final boolean ordered;
    private final PriorityQueue<Task> queue = new PriorityQueue();
    private final AtomicLong nextId = new AtomicLong();
    private final AtomicLong index = new AtomicLong();
    private final ReentrantLock lock;
    private final Condition available;

    public AsyncCompletionService(Executor executor, boolean ordered) {
        this(executor, ordered, null);
    }

    public AsyncCompletionService(Executor executor, boolean ordered, ReentrantLock lock) {
        this.executor = executor;
        this.ordered = ordered;
        this.lock = lock != null ? lock : new ReentrantLock();
        this.available = this.lock.newCondition();
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public void submit(Consumer<Consumer<V>> runner) {
        Task f = new Task(this.nextId.getAndIncrement(), runner);
        this.executor.execute(f);
    }

    public void skip() {
        this.index.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V pollUnordered() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Task t = this.queue.poll();
            Object object = t != null ? t.result : null;
            return (V)object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Task t = this.queue.peek();
            if (t != null && (!this.ordered || this.index.compareAndSet(t.id, t.id + 1L))) {
                this.queue.poll();
                Object object = t.result;
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    public V poll(long timeout2, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout2);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                Task t;
                if ((t = this.queue.peek()) != null && (!this.ordered || this.index.compareAndSet(t.id, t.id + 1L))) {
                    this.queue.poll();
                    Object object = t.result;
                    return (V)object;
                }
                if (nanos <= 0L) {
                    V v = null;
                    return v;
                }
                nanos = this.available.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public V take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                Task t;
                if ((t = this.queue.peek()) != null && (!this.ordered || this.index.compareAndSet(t.id, t.id + 1L))) {
                    this.queue.poll();
                    Object object = t.result;
                    return (V)object;
                }
                this.available.await();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void complete(Task task) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.queue.add(task);
            this.available.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    private class Task
    implements Runnable,
    Comparable<Task> {
        private final long id;
        private final Consumer<Consumer<V>> runner;
        private V result;

        Task(long id, Consumer<Consumer<V>> runner) {
            this.id = id;
            this.runner = runner;
        }

        @Override
        public void run() {
            this.runner.accept(this::setResult);
        }

        protected void setResult(V result) {
            this.result = result;
            AsyncCompletionService.this.complete(this);
        }

        @Override
        public int compareTo(Task other) {
            return Long.compare(this.id, other.id);
        }

        public String toString() {
            return "SubmitOrderedFutureTask[" + this.id + "]";
        }
    }
}

