/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.schwering.irc.lib.IRCEventAdapter;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;
import org.slf4j.Logger;

public class IrcLogger
extends IRCEventAdapter {
    private Logger log;
    private String server;

    public IrcLogger(Logger log, String server) {
        this.log = log;
        this.server = server;
    }

    @Override
    public void onDisconnected() {
        this.log.info("Server: " + this.server + " - onDisconnected");
    }

    @Override
    public void onError(int num, String msg) {
        this.log.error("Server: " + this.server + " - onError num=" + num + " msg=\"" + msg + "\"");
    }

    @Override
    public void onError(String msg) {
        this.log.error("Server: " + this.server + " - onError msg=\"" + msg + "\"");
    }

    @Override
    public void onInvite(String chan, IRCUser user, String passiveNick) {
        this.log.debug("Server: " + this.server + " - onInvite chan=" + chan + " user=" + user + " passiveNick=" + passiveNick);
    }

    @Override
    public void onJoin(String chan, IRCUser user) {
        this.log.debug("Server: " + this.server + " - onJoin chan=" + chan + " user=" + user);
    }

    @Override
    public void onKick(String chan, IRCUser user, String passiveNick, String msg) {
        this.log.debug("Server: " + this.server + " - onKick chan=" + chan + " user=" + user + " passiveNick=" + passiveNick + " msg=\"" + msg + "\"");
    }

    @Override
    public void onMode(String chan, IRCUser user, IRCModeParser ircModeParser) {
        this.log.info("Server: " + this.server + " - onMode chan=" + chan + " user=" + user + " ircModeParser=" + ircModeParser);
    }

    @Override
    public void onMode(IRCUser user, String passiveNick, String mode) {
        this.log.info("Server: " + this.server + " - onMode user=" + user + " passiveNick=" + passiveNick + " mode=" + mode);
    }

    @Override
    public void onNick(IRCUser user, String newNick) {
        this.log.debug("Server: " + this.server + " - onNick user=" + user + " newNick=" + newNick);
    }

    @Override
    public void onNotice(String target, IRCUser user, String msg) {
        this.log.debug("Server: " + this.server + " - onNotice target=" + target + " user=" + user + " msg=\"" + msg + "\"");
    }

    @Override
    public void onPart(String chan, IRCUser user, String msg) {
        this.log.debug("Server: " + this.server + " - onPart chan=" + chan + " user=" + user + " msg=\"" + msg + "\"");
    }

    @Override
    public void onPing(String ping) {
        this.log.info("Server: " + this.server + " - onPing ping=" + ping);
    }

    @Override
    public void onPrivmsg(String target, IRCUser user, String msg) {
        this.log.debug("Server: " + this.server + " - onPrivmsg target=" + target + " user=" + user + " msg=\"" + msg + "\"");
    }

    @Override
    public void onQuit(IRCUser user, String msg) {
        this.log.debug("Server: " + this.server + " - onQuit user=" + user + " msg=\"" + msg + "\"");
    }

    @Override
    public void onRegistered() {
        this.log.info("Server: " + this.server + " - onRegistered");
    }

    @Override
    public void onReply(int num, String value, String msg) {
        this.log.debug("Server: " + this.server + " - onReply num=" + num + " value=\"" + value + "\" msg=\"" + msg + "\"");
    }

    @Override
    public void onTopic(String chan, IRCUser user, String topic) {
        this.log.debug("Server: " + this.server + " - onTopic chan=" + chan + " user=" + user + " topic=" + topic);
    }

    @Override
    public void unknown(String prefix, String command, String middle, String trailing) {
        this.log.info("Server: " + this.server + " - unknown prefix=" + prefix + " command=" + command + " middle=" + middle + " trailing=" + trailing);
    }
}

