/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.irc.IrcChannel;
import org.apache.camel.component.irc.IrcEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventAdapter;
import org.schwering.irc.lib.IRCUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrcProducer
extends DefaultProducer {
    public static final String[] COMMANDS = new String[]{"AWAY", "INVITE", "ISON", "JOIN", "KICK", "LIST", "NAMES", "PRIVMSG", "MODE", "NICK", "NOTICE", "PART", "PONG", "QUIT", "TOPIC", "WHO", "WHOIS", "WHOWAS", "USERHOST"};
    private static final Logger LOG = LoggerFactory.getLogger(IrcProducer.class);
    private IRCConnection connection;
    private IrcEndpoint endpoint;
    private IRCEventAdapter listener;

    public IrcProducer(IrcEndpoint endpoint, IRCConnection connection) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.connection = connection;
    }

    public void process(Exchange exchange) throws Exception {
        String msg = (String)exchange.getIn().getBody(String.class);
        String targetChannel = (String)exchange.getIn().getHeader("irc.target", String.class);
        if (!this.connection.isConnected()) {
            throw new RuntimeCamelException("Lost connection to " + this.connection.getHost());
        }
        if (msg != null) {
            if (this.isMessageACommand(msg)) {
                LOG.debug("Sending command: {}", (Object)msg);
                this.connection.send(msg);
            } else if (targetChannel != null) {
                LOG.debug("Sending to: {} message: {}", (Object)targetChannel, (Object)msg);
                this.connection.doPrivmsg(targetChannel, msg);
            } else {
                for (IrcChannel channel : this.endpoint.getConfiguration().getChannels()) {
                    LOG.debug("Sending to: {} message: {}", (Object)channel, (Object)msg);
                    this.connection.doPrivmsg(channel.getName(), msg);
                }
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.listener = this.getListener();
        this.connection.addIRCEventListener(this.listener);
        this.endpoint.joinChannels();
    }

    protected void doStop() throws Exception {
        if (this.connection != null) {
            for (IrcChannel channel : this.endpoint.getConfiguration().getChannels()) {
                LOG.debug("Parting: {}", (Object)channel);
                this.connection.doPart(channel.getName());
            }
            this.connection.removeIRCEventListener(this.listener);
        }
        super.doStop();
    }

    protected boolean isMessageACommand(String msg) {
        for (String command : COMMANDS) {
            if (!msg.startsWith(command)) continue;
            return true;
        }
        return false;
    }

    public IRCEventAdapter getListener() {
        if (this.listener == null) {
            this.listener = new FilteredIRCEventAdapter();
        }
        return this.listener;
    }

    public void setListener(IRCEventAdapter listener) {
        this.listener = listener;
    }

    class FilteredIRCEventAdapter
    extends IRCEventAdapter {
        FilteredIRCEventAdapter() {
        }

        @Override
        public void onKick(String channel, IRCUser user, String passiveNick, String msg) {
            if (passiveNick.equals(IrcProducer.this.connection.getNick()) && IrcProducer.this.endpoint.getConfiguration().isAutoRejoin()) {
                IrcProducer.this.endpoint.joinChannel(channel);
            }
        }

        @Override
        public void onError(int num, String msg) {
            IrcProducer.this.endpoint.handleIrcError(num, msg);
        }
    }
}

