/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.schwering.irc.lib.ssl.SSLIRCConnection;
import org.schwering.irc.lib.ssl.SSLNotSupportedException;

public class CamelSSLIRCConnection
extends SSLIRCConnection {
    private SSLContextParameters sslContextParameters;
    private CamelContext camelContext;

    public CamelSSLIRCConnection(String host, int portMin, int portMax, String pass, String nick, String username, String realname, SSLContextParameters sslContextParameters) {
        super(host, portMin, portMax, pass, nick, username, realname);
        this.sslContextParameters = sslContextParameters;
    }

    public CamelSSLIRCConnection(String host, int[] ports, String pass, String nick, String username, String realname, SSLContextParameters sslContextParameters, CamelContext camelContext) {
        super(host, ports, pass, nick, username, realname);
        this.sslContextParameters = sslContextParameters;
        this.camelContext = camelContext;
    }

    @Override
    public void connect() throws IOException {
        if (this.sslContextParameters == null) {
            super.connect();
        } else {
            SSLContext sslContext;
            if (this.level != 0) {
                throw new SocketException("Socket closed or already open (" + this.level + ")");
            }
            IOException exception = null;
            try {
                sslContext = this.sslContextParameters.createSSLContext(this.camelContext);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeCamelException("Error in SSLContextParameters configuration or instantiation.", e);
            }
            SSLSocketFactory sf = sslContext.getSocketFactory();
            Socket s = null;
            for (int i = 0; i < this.ports.length && s == null; ++i) {
                try {
                    s = (SSLSocket)sf.createSocket(this.host, this.ports[i]);
                    ((SSLSocket)s).startHandshake();
                    exception = null;
                    continue;
                }
                catch (SSLNotSupportedException exc) {
                    if (s != null) {
                        s.close();
                    }
                    s = null;
                    throw exc;
                }
                catch (IOException exc) {
                    if (s != null) {
                        s.close();
                    }
                    s = null;
                    exception = exc;
                }
            }
            if (exception != null) {
                throw exception;
            }
            this.prepare(s);
        }
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }
}

