/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.apache.camel.Category;
import org.apache.camel.Processor;
import org.apache.camel.component.irc.IrcBinding;
import org.apache.camel.component.irc.IrcChannel;
import org.apache.camel.component.irc.IrcComponent;
import org.apache.camel.component.irc.IrcConfiguration;
import org.apache.camel.component.irc.IrcConsumer;
import org.apache.camel.component.irc.IrcProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.schwering.irc.lib.IRCConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="1.1.0", scheme="irc", title="IRC", syntax="irc:hostname:port", alternativeSyntax="irc:username:password@hostname:port", category={Category.CHAT})
public class IrcEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(IrcEndpoint.class);
    @UriParam
    private IrcConfiguration configuration;
    private IrcBinding binding;
    private IrcComponent component;

    public IrcEndpoint(String endpointUri, IrcComponent component, IrcConfiguration configuration) {
        super(UnsafeUriCharactersEncoder.encode(endpointUri), component);
        this.component = component;
        this.configuration = configuration;
    }

    @Override
    public IrcProducer createProducer() throws Exception {
        return new IrcProducer(this);
    }

    @Override
    public IrcConsumer createConsumer(Processor processor) throws Exception {
        IrcConsumer answer = new IrcConsumer(this, processor, this.component.getIRCConnection(this.configuration));
        this.configureConsumer(answer);
        return answer;
    }

    @Override
    public IrcComponent getComponent() {
        return this.component;
    }

    public void setComponent(IrcComponent component) {
        this.component = component;
    }

    public IrcBinding getBinding() {
        if (this.binding == null) {
            this.binding = new IrcBinding();
        }
        return this.binding;
    }

    public void setBinding(IrcBinding binding) {
        this.binding = binding;
    }

    public IrcConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IrcConfiguration configuration) {
        this.configuration = configuration;
    }

    public void handleIrcError(int num, String msg) {
        if (433 == num) {
            this.handleNickInUse();
        }
    }

    private void handleNickInUse() {
        IRCConnection connection = this.component.getIRCConnection(this.configuration);
        String nick = connection.getNick() + "-";
        if (nick.endsWith("----")) {
            LOG.error("Unable to set nick: {} disconnecting", (Object)nick);
        } else {
            LOG.warn("Unable to set nick: {} Retrying with {} -", (Object)nick, (Object)nick);
            connection.doNick(nick);
            this.joinChannels();
        }
    }

    public void joinChannels() {
        for (IrcChannel channel : this.configuration.getChannelList()) {
            this.joinChannel(channel);
        }
    }

    public void joinChannel(String name) {
        this.joinChannel(this.configuration.findChannel(name));
    }

    public void joinChannel(IrcChannel channel) {
        if (channel == null) {
            return;
        }
        IRCConnection connection = this.component.getIRCConnection(this.configuration);
        String chn = channel.getName();
        String key = channel.getKey();
        if (ObjectHelper.isNotEmpty(key)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Joining: {} using {} with secret key", (Object)channel, (Object)connection.getClass().getName());
            }
            connection.doJoin(chn, key);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Joining: {} using {}", (Object)channel, (Object)connection.getClass().getName());
            }
            connection.doJoin(chn);
        }
        if (this.configuration.isNamesOnJoin()) {
            connection.doNames(chn);
        }
    }
}

