/*
 * Decompiled with CFR 0.152.
 */
package io.iron.ironmq;

import com.google.gson.Gson;
import io.iron.ironmq.Client;
import io.iron.ironmq.IronReader;
import io.iron.ironmq.QueueModel;
import io.iron.ironmq.QueuesContainer;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;

public class Queues {
    private final Client client;

    public Queues(Client client) {
        this.client = client;
    }

    @Deprecated
    public ArrayList<QueueModel> getAllQueues() throws IOException {
        return Queues.getQueues(this.client);
    }

    public static ArrayList<QueueModel> getQueues(Client client) throws IOException {
        return Queues.getQueues(client, null, null, null);
    }

    public static ArrayList<QueueModel> getQueues(Client client, int perPage) throws IOException {
        return Queues.getQueues(client, null, perPage, null);
    }

    public static ArrayList<QueueModel> getQueues(Client client, String previousQueueName) throws IOException {
        return Queues.getQueues(client, previousQueueName, null, null);
    }

    public static ArrayList<QueueModel> getQueues(Client client, String previousQueueName, Integer perPage, String prefix) throws IOException {
        StringBuilder params = new StringBuilder();
        if (previousQueueName != null && !previousQueueName.isEmpty()) {
            params.append(String.format("previous=%s", URLEncoder.encode(previousQueueName, "UTF-8")));
        }
        if (prefix != null && !prefix.isEmpty()) {
            params.append(String.format("%sprefix=%s", params.length() > 0 ? "&" : "", URLEncoder.encode(prefix, "UTF-8")));
        }
        if (perPage != null) {
            if (perPage < 1) {
                throw new IllegalArgumentException("perPage parameter should be greater than 0");
            }
            params.append(String.format("%sper_page=%d", params.length() > 0 ? "&" : "", perPage));
        }
        String url = "queues?" + params;
        IronReader reader = client.get(url);
        Gson gson = new Gson();
        QueuesContainer queues = gson.fromJson(reader.reader, QueuesContainer.class);
        reader.close();
        return queues.getQueues();
    }
}

