/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerAware;
import org.apache.camel.util.ObjectHelper;

public final class ExpressionToPredicateAdapter
implements Predicate,
CamelContextAware,
PropertyConfigurerAware {
    private final Expression expression;

    public ExpressionToPredicateAdapter(Expression expression) {
        this.expression = expression;
    }

    @Override
    public boolean matches(Exchange exchange) {
        if (this.expression instanceof Predicate) {
            return ((Predicate)((Object)this.expression)).matches(exchange);
        }
        Object value = this.expression.evaluate(exchange, Object.class);
        return ObjectHelper.evaluateValuePredicate(value);
    }

    public String toString() {
        return this.expression.toString();
    }

    public static Predicate toPredicate(Expression expression) {
        if (expression instanceof Predicate) {
            return (Predicate)((Object)expression);
        }
        return new ExpressionToPredicateAdapter(expression);
    }

    @Override
    public void init(CamelContext context) {
        this.expression.init(context);
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        CamelContextAware.trySetCamelContext(this.expression, camelContext);
    }

    @Override
    public CamelContext getCamelContext() {
        if (this.expression instanceof CamelContextAware) {
            return ((CamelContextAware)((Object)this.expression)).getCamelContext();
        }
        return null;
    }

    @Override
    public PropertyConfigurer getPropertyConfigurer(Object instance) {
        if (this.expression instanceof PropertyConfigurer) {
            return (PropertyConfigurer)((Object)this.expression);
        }
        if (this.expression instanceof PropertyConfigurerAware) {
            return ((PropertyConfigurerAware)((Object)this.expression)).getPropertyConfigurer(this.expression);
        }
        return null;
    }
}

