/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.StorageMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.io.ContentMetadata;
import org.jclouds.javax.annotation.Nullable;

public class BlobMetadataImpl
extends StorageMetadataImpl
implements BlobMetadata {
    private final URI publicUri;
    private final String container;
    private final ContentMetadata contentMetadata;

    public BlobMetadataImpl(String id, String name, @Nullable Location location, URI uri, String eTag, @Nullable Date creationDate, @Nullable Date lastModified, Map<String, String> userMetadata, @Nullable URI publicUri, @Nullable String container, ContentMetadata contentMetadata, @Nullable Long size) {
        super(StorageType.BLOB, id, name, location, uri, eTag, creationDate, lastModified, userMetadata, size);
        this.publicUri = publicUri;
        this.container = container;
        this.contentMetadata = Preconditions.checkNotNull(contentMetadata, "contentMetadata");
    }

    @Deprecated
    public BlobMetadataImpl(String id, String name, @Nullable Location location, URI uri, String eTag, @Nullable Date creationDate, @Nullable Date lastModified, Map<String, String> userMetadata, @Nullable URI publicUri, @Nullable String container, ContentMetadata contentMetadata) {
        this(id, name, location, uri, eTag, creationDate, lastModified, userMetadata, publicUri, container, contentMetadata, null);
    }

    @Override
    public URI getPublicUri() {
        return this.publicUri;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public ContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BlobMetadataImpl)) {
            return false;
        }
        BlobMetadataImpl that = (BlobMetadataImpl)object;
        return super.equals(that) && Objects.equal(this.publicUri, that.publicUri) && Objects.equal(this.container, that.container) && Objects.equal(this.contentMetadata, that.contentMetadata);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.publicUri, this.container, this.contentMetadata);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("publicUri", this.publicUri).add("container", this.container).add("contentMetadata", this.contentMetadata);
    }
}

