/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.inject.Named;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.internal.MultipartUploadSlicingAlgorithm;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.util.Closeables2;
import org.jclouds.util.Predicates2;

public abstract class BaseBlobStore
implements BlobStore {
    protected final BlobStoreContext context;
    protected final BlobUtils blobUtils;
    protected final Supplier<Location> defaultLocation;
    protected final Supplier<Set<? extends Location>> locations;
    protected final PayloadSlicer slicer;
    @Inject
    @Named(value="jclouds.user-threads")
    @VisibleForTesting
    ListeningExecutorService userExecutor;

    @javax.inject.Inject
    protected BaseBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, PayloadSlicer slicer) {
        this.context = Preconditions.checkNotNull(context, "context");
        this.blobUtils = Preconditions.checkNotNull(blobUtils, "blobUtils");
        this.defaultLocation = Preconditions.checkNotNull(defaultLocation, "defaultLocation");
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.slicer = Preconditions.checkNotNull(slicer, "slicer");
    }

    @Override
    public BlobStoreContext getContext() {
        return this.context;
    }

    @Override
    public BlobBuilder blobBuilder(String name) {
        return this.blobUtils.blobBuilder().name(name);
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String container) {
        return this.list(container, ListContainerOptions.NONE);
    }

    @Override
    public boolean directoryExists(String containerName, String directory) {
        return this.blobUtils.directoryExists(containerName, directory);
    }

    @Override
    public void createDirectory(String containerName, String directory) {
        this.blobUtils.createDirectory(containerName, directory);
    }

    @Override
    public void removeBlobs(String container, Iterable<String> names) {
        for (String name : names) {
            this.removeBlob(container, name);
        }
    }

    @Override
    public long countBlobs(String container) {
        return this.countBlobs(container, ListContainerOptions.Builder.recursive());
    }

    @Override
    public long countBlobs(String containerName, ListContainerOptions options) {
        return this.blobUtils.countBlobs(containerName, options);
    }

    @Override
    public void clearContainer(String containerName) {
        this.clearContainer(containerName, ListContainerOptions.Builder.recursive());
    }

    @Override
    public void clearContainer(String containerName, ListContainerOptions options) {
        this.blobUtils.clearContainer(containerName, options);
    }

    @Override
    public void deleteDirectory(String containerName, String directory) {
        this.blobUtils.deleteDirectory(containerName, directory);
    }

    @Override
    public Blob getBlob(String container, String key) {
        return this.getBlob(container, key, GetOptions.NONE);
    }

    @Override
    public void deleteContainer(String container) {
        this.deletePathAndEnsureGone(container);
    }

    @Override
    public boolean deleteContainerIfEmpty(String container) {
        try {
            return this.deleteAndVerifyContainerGone(container);
        }
        catch (ContainerNotFoundException cnfe) {
            return true;
        }
    }

    protected void deletePathAndEnsureGone(String path) {
        Preconditions.checkState(Predicates2.retry(new Predicate<String>(){

            @Override
            public boolean apply(String in) {
                try {
                    BaseBlobStore.this.clearContainer(in, ListContainerOptions.Builder.recursive());
                    return BaseBlobStore.this.deleteAndVerifyContainerGone(in);
                }
                catch (ContainerNotFoundException e) {
                    return true;
                }
            }
        }, 30000L).apply(path), "%s still exists after deleting!", path);
    }

    @Override
    public Set<? extends Location> listAssignableLocations() {
        return this.locations.get();
    }

    protected abstract boolean deleteAndVerifyContainerGone(String var1);

    @Override
    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        Date lastModified;
        Blob blob = this.getBlob(fromContainer, fromName);
        if (blob == null) {
            throw new KeyNotFoundException(fromContainer, fromName, "while copying");
        }
        String eTag = blob.getMetadata().getETag();
        if (eTag != null) {
            eTag = BaseBlobStore.maybeQuoteETag(eTag);
            if (options.ifMatch() != null && !BaseBlobStore.maybeQuoteETag(options.ifMatch()).equals(eTag)) {
                throw BaseBlobStore.returnResponseException(412);
            }
            if (options.ifNoneMatch() != null && BaseBlobStore.maybeQuoteETag(options.ifNoneMatch()).equals(eTag)) {
                throw BaseBlobStore.returnResponseException(412);
            }
        }
        if ((lastModified = blob.getMetadata().getLastModified()) != null) {
            if (options.ifModifiedSince() != null && lastModified.compareTo(options.ifModifiedSince()) <= 0) {
                throw BaseBlobStore.returnResponseException(412);
            }
            if (options.ifUnmodifiedSince() != null && lastModified.compareTo(options.ifUnmodifiedSince()) >= 0) {
                throw BaseBlobStore.returnResponseException(412);
            }
        }
        InputStream is = null;
        try {
            is = blob.getPayload().openStream();
            BlobBuilder.PayloadBlobBuilder builder = this.blobBuilder(toName).payload(is);
            Long contentLength = blob.getMetadata().getContentMetadata().getContentLength();
            if (contentLength != null) {
                builder.contentLength(contentLength);
            }
            ContentMetadata metadata = options.contentMetadata() != null ? options.contentMetadata() : blob.getMetadata().getContentMetadata();
            builder.cacheControl(metadata.getCacheControl()).contentDisposition(metadata.getContentDisposition()).contentEncoding(metadata.getContentEncoding()).contentLanguage(metadata.getContentLanguage()).contentType(metadata.getContentType());
            Map<String, String> userMetadata = options.userMetadata();
            if (userMetadata != null) {
                builder.userMetadata(userMetadata);
            } else {
                builder.userMetadata(blob.getMetadata().getUserMetadata());
            }
            String string = this.putBlob(toContainer, builder.build());
            return string;
        }
        catch (IOException ioe) {
            throw Throwables.propagate(ioe);
        }
        finally {
            Closeables2.closeQuietly(is);
        }
    }

    @Beta
    protected String putMultipartBlob(String container, Blob blob, PutOptions overrides) {
        if (overrides.getUseCustomExecutor()) {
            return this.putMultipartBlob(container, blob, overrides, overrides.getCustomExecutor());
        }
        return this.putMultipartBlob(container, blob, overrides, this.userExecutor);
    }

    @Beta
    protected String putMultipartBlob(String container, Blob blob, PutOptions overrides, ListeningExecutorService executor) {
        ArrayList<ListenableFuture<MultipartPart>> parts = new ArrayList<ListenableFuture<MultipartPart>>();
        MultipartUpload mpu = this.initiateMultipartUpload(container, blob.getMetadata(), overrides);
        try {
            long contentLength = blob.getMetadata().getContentMetadata().getContentLength();
            MultipartUploadSlicingAlgorithm algorithm = new MultipartUploadSlicingAlgorithm(this.getMinimumMultipartPartSize(), this.getMaximumMultipartPartSize(), this.getMaximumNumberOfParts());
            long partSize = algorithm.calculateChunkSize(contentLength);
            int partNumber = 1;
            for (Payload payload : this.slicer.slice(blob.getPayload(), partSize)) {
                BlobUploader b = new BlobUploader(mpu, partNumber++, payload);
                parts.add(executor.submit(b));
            }
            return this.completeMultipartUpload(mpu, Futures.getUnchecked(Futures.allAsList(parts)));
        }
        catch (RuntimeException re) {
            this.abortMultipartUpload(mpu);
            throw re;
        }
    }

    private static HttpResponseException returnResponseException(int code) {
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(code)).build();
        return new HttpResponseException(new HttpCommand(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET")).endpoint("http://stub")).build()), response);
    }

    private static String maybeQuoteETag(String eTag) {
        if (!eTag.startsWith("\"") && !eTag.endsWith("\"")) {
            eTag = "\"" + eTag + "\"";
        }
        return eTag;
    }

    @Override
    public void downloadBlob(String container, String name, File destination) {
        throw new UnsupportedOperationException("Operation not supported yet");
    }

    @Override
    public void downloadBlob(String container, String name, File destination, ExecutorService executor) {
        throw new UnsupportedOperationException("Operation not supported yet");
    }

    @Override
    public InputStream streamBlob(String container, String name) {
        throw new UnsupportedOperationException("Operation not supported yet");
    }

    @Override
    public InputStream streamBlob(String container, String name, ExecutorService executor) {
        throw new UnsupportedOperationException("Operation not supported yet");
    }

    private final class BlobUploader
    implements Callable<MultipartPart> {
        private final MultipartUpload mpu;
        private final int partNumber;
        private final Payload payload;

        BlobUploader(MultipartUpload mpu, int partNumber, Payload payload) {
            this.mpu = mpu;
            this.partNumber = partNumber;
            this.payload = payload;
        }

        @Override
        public MultipartPart call() {
            return BaseBlobStore.this.uploadMultipartPart(this.mpu, this.partNumber, this.payload);
        }
    }
}

