/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.javax.annotation.concurrent.NotThreadSafe;
import org.jclouds.logging.Logger;

@NotThreadSafe
public class FetchBlobMetadata
implements Function<PageSet<? extends StorageMetadata>, PageSet<? extends StorageMetadata>> {
    protected final BackoffLimitedRetryHandler retryHandler;
    protected final BlobStore blobstore;
    protected final ListeningExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    private String container;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    FetchBlobMetadata(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, BlobStore blobstore, BackoffLimitedRetryHandler retryHandler) {
        this.userExecutor = userExecutor;
        this.blobstore = blobstore;
        this.retryHandler = retryHandler;
    }

    public FetchBlobMetadata setContainerName(String container) {
        this.container = container;
        return this;
    }

    @Override
    public PageSet<? extends StorageMetadata> apply(PageSet<? extends StorageMetadata> in) {
        Preconditions.checkState(this.container != null, "container name should be initialized");
        ArrayList<? extends BlobMetadata> returnv = Lists.newArrayList(FutureIterables.transformParallel(Iterables.filter(in, new Predicate<StorageMetadata>(){

            @Override
            public boolean apply(StorageMetadata input) {
                return input.getType() == StorageType.BLOB;
            }
        }), new Function<StorageMetadata, ListenableFuture<? extends BlobMetadata>>(){

            @Override
            public ListenableFuture<BlobMetadata> apply(final StorageMetadata from) {
                return FetchBlobMetadata.this.userExecutor.submit(new Callable<BlobMetadata>(){

                    @Override
                    public BlobMetadata call() throws Exception {
                        return FetchBlobMetadata.this.blobstore.blobMetadata(FetchBlobMetadata.this.container, from.getName());
                    }
                });
            }
        }, this.userExecutor, this.maxTime, this.logger, String.format("getting metadata from containerName: %s", this.container)));
        return new PageSetImpl<BlobMetadata>(returnv, in.getNextMarker());
    }
}

