/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.extensions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.suppliers.ImageCacheSupplier;

@Beta
public class DelegatingImageExtension
implements ImageExtension {
    private final ImageCacheSupplier imageCache;
    private final ImageExtension delegate;

    public DelegatingImageExtension(ImageCacheSupplier imageCache, ImageExtension delegate) {
        this.imageCache = Preconditions.checkNotNull(imageCache, "imageCache");
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
    }

    @Override
    public ImageTemplate buildImageTemplateFromNode(String name, String id) {
        return this.delegate.buildImageTemplateFromNode(name, id);
    }

    @Override
    public ListenableFuture<Image> createImage(ImageTemplate template) {
        ListenableFuture<Image> future = this.delegate.createImage(template);
        Futures.addCallback(future, new FutureCallback<Image>(){

            @Override
            public void onSuccess(Image result) {
                DelegatingImageExtension.this.imageCache.registerImage(result);
            }

            @Override
            public void onFailure(Throwable t) {
            }
        });
        return future;
    }

    @Override
    public boolean deleteImage(String id) {
        boolean success = this.delegate.deleteImage(id);
        if (success) {
            this.imageCache.removeImage(id);
        }
        return success;
    }
}

