/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.reflect;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;

@Beta
public class Reflection2 {
    private static LoadingCache<TypeToken<?>, Set<Invokable<?, ?>>> constructorsForTypeToken = CacheBuilder.newBuilder().build(new CacheLoader<TypeToken<?>, Set<Invokable<?, ?>>>(){

        @Override
        public Set<Invokable<?, ?>> load(TypeToken<?> key) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Constructor<?> ctor : key.getRawType().getDeclaredConstructors()) {
                ctor.setAccessible(true);
                builder.add(key.constructor(ctor));
            }
            if (Modifier.isAbstract(key.getRawType().getModifiers())) {
                for (Invokable invokable : Reflection2.methods(key.getRawType())) {
                    if (!invokable.isStatic() || !invokable.getReturnType().equals(key)) continue;
                    invokable.setAccessible(true);
                    builder.add(invokable);
                }
            }
            return builder.build();
        }
    });
    private static LoadingCache<Type, TypeToken<?>> typeTokenForType = CacheBuilder.newBuilder().build(new CacheLoader<Type, TypeToken<?>>(){

        @Override
        public TypeToken<?> load(Type key) {
            return TypeToken.of(key);
        }
    });
    private static LoadingCache<Class<?>, TypeToken<?>> typeTokenForClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, TypeToken<?>>(){

        @Override
        public TypeToken<?> load(Class<?> key) {
            return TypeToken.of(key);
        }
    });
    private static LoadingCache<TypeTokenAndParameterTypes, Invokable<?, ?>> constructorForParams = CacheBuilder.newBuilder().build(new CacheLoader<TypeTokenAndParameterTypes, Invokable<?, ?>>(){

        @Override
        public Invokable<?, ?> load(final TypeTokenAndParameterTypes key) {
            Set constructors = (Set)Reflection2.get(constructorsForTypeToken, key.type);
            Optional constructor = Iterables.tryFind(constructors, new Predicate<Invokable<?, ?>>(){

                @Override
                public boolean apply(Invokable<?, ?> input) {
                    return Objects.equal(Reflection2.toClasses(input.getParameters()), key.parameterTypes);
                }
            });
            if (constructor.isPresent()) {
                return (Invokable)constructor.get();
            }
            throw new IllegalArgumentException("no such constructor " + key.toString() + "in: " + constructors);
        }
    });
    private static final LoadingCache<Invokable<?, ?>, ImmutableList<Parameter>> invokableParamsCache = CacheBuilder.newBuilder().maximumSize(100L).build(new CacheLoader<Invokable<?, ?>, ImmutableList<Parameter>>(){

        @Override
        public ImmutableList<Parameter> load(Invokable<?, ?> invokable) {
            return invokable.getParameters();
        }
    });
    private static LoadingCache<TypeTokenNameAndParameterTypes, Invokable<?, ?>> methodForParams = CacheBuilder.newBuilder().build(new CacheLoader<TypeTokenNameAndParameterTypes, Invokable<?, ?>>(){

        @Override
        public Invokable<?, ?> load(final TypeTokenNameAndParameterTypes key) {
            Set methods = (Set)Reflection2.get(methodsForTypeToken, key.type);
            Optional method = Iterables.tryFind(methods, new Predicate<Invokable<?, ?>>(){

                @Override
                public boolean apply(Invokable<?, ?> input) {
                    return !input.isSynthetic() && Objects.equal(input.getName(), key.name) && Objects.equal(Reflection2.toClasses(input.getParameters()), key.parameterTypes);
                }
            });
            Preconditions.checkArgument(method.isPresent(), "no such method %s in: %s", key.toString(), methods);
            return (Invokable)method.get();
        }
    });
    private static LoadingCache<TypeToken<?>, Set<Invokable<?, ?>>> methodsForTypeToken = CacheBuilder.newBuilder().build(new CacheLoader<TypeToken<?>, Set<Invokable<?, ?>>>(){

        @Override
        public Set<Invokable<?, ?>> load(TypeToken<?> key) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (TypeToken token : key.getTypes()) {
                Class raw = token.getRawType();
                if (raw == Object.class) continue;
                for (Method method : raw.getDeclaredMethods()) {
                    if (!Reflection2.coreJavaClass(raw)) {
                        method.setAccessible(true);
                    }
                    builder.add(key.method(method));
                }
            }
            return builder.build();
        }
    });

    public static <T> TypeToken<T> typeToken(Type in) {
        return Reflection2.get(typeTokenForType, Preconditions.checkNotNull(in, "class"));
    }

    public static <T> TypeToken<T> typeToken(Class<T> in) {
        return Reflection2.get(typeTokenForClass, Preconditions.checkNotNull(in, "class"));
    }

    public static <T> Invokable<T, T> constructor(Class<T> ownerType, Class<?> ... parameterTypes) {
        return Reflection2.get(constructorForParams, new TypeTokenAndParameterTypes(Reflection2.typeToken(ownerType), parameterTypes));
    }

    public static <T> Collection<Invokable<T, T>> constructors(TypeToken<T> ownerType) {
        return (Collection)Collection.class.cast(Reflection2.get(constructorsForTypeToken, ownerType));
    }

    public static <T, R> Invokable<T, R> method(TypeToken<T> ownerType, Method method) {
        return Reflection2.method(ownerType.getRawType(), method.getName(), method.getParameterTypes());
    }

    public static <T, R> Invokable<T, R> method(Class<T> ownerType, String name, Class<?> ... parameterTypes) {
        return Reflection2.get(methodForParams, new TypeTokenNameAndParameterTypes(Reflection2.typeToken(ownerType), name, parameterTypes));
    }

    public static <T> Collection<Invokable<T, Object>> methods(Class<T> ownerType) {
        return (Collection)Collection.class.cast(Reflection2.get(methodsForTypeToken, Reflection2.typeToken(ownerType)));
    }

    protected static List<Class<?>> toClasses(ImmutableList<Parameter> params) {
        return Lists.transform(params, new Function<Parameter, Class<?>>(){

            @Override
            public Class<?> apply(Parameter input) {
                return input.getType().getRawType();
            }
        });
    }

    public static List<Parameter> getInvokableParameters(Invokable<?, ?> invokable) {
        return invokableParamsCache.getUnchecked(invokable);
    }

    private static boolean coreJavaClass(Class<?> clazz) {
        Package clazzPackage = clazz.getPackage();
        if (clazzPackage == null) {
            return false;
        }
        String packageName = clazzPackage.getName();
        return packageName.startsWith("com.sun.") || packageName.startsWith("java.") || packageName.startsWith("javax.") || packageName.startsWith("sun.");
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return cache.get(key);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
        catch (ExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    private static class TypeTokenNameAndParameterTypes
    extends TypeTokenAndParameterTypes {
        private String name;

        public TypeTokenNameAndParameterTypes(TypeToken<?> type, String name, Class<?> ... parameterTypes) {
            super(type, parameterTypes);
            this.name = Preconditions.checkNotNull(name, "name");
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(super.hashCode(), this.name);
        }

        @Override
        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                TypeTokenNameAndParameterTypes that = (TypeTokenNameAndParameterTypes)TypeTokenNameAndParameterTypes.class.cast(obj);
                return this.name.equals(that.name);
            }
            return false;
        }

        @Override
        public String toString() {
            return Objects.toStringHelper("").add("type", this.type).add("name", this.name).add("parameterTypes", this.parameterTypes).toString();
        }
    }

    private static class TypeTokenAndParameterTypes {
        protected TypeToken<?> type;
        protected List<Class<?>> parameterTypes;

        public TypeTokenAndParameterTypes(TypeToken<?> type, Class<?> ... parameterTypes) {
            this.type = Preconditions.checkNotNull(type, "type");
            this.parameterTypes = Arrays.asList((Object[])Preconditions.checkNotNull(parameterTypes, "parameterTypes"));
        }

        public int hashCode() {
            return Objects.hashCode(this.type, this.parameterTypes);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TypeTokenAndParameterTypes that = (TypeTokenAndParameterTypes)TypeTokenAndParameterTypes.class.cast(obj);
            return Objects.equal(this.type, that.type) && Objects.equal(this.parameterTypes, that.parameterTypes);
        }

        public String toString() {
            return Objects.toStringHelper("").add("type", this.type).add("parameterTypes", this.parameterTypes).toString();
        }
    }
}

