/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain.chef;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.jclouds.scriptbuilder.domain.chef.RunList;

public class Role {
    private String name;
    private Optional<String> description;
    private Optional<String> jsonDefaultAttributes;
    private Optional<String> jsonOverrideAttributes;
    private RunList runlist;

    public static Builder builder() {
        return new Builder();
    }

    protected Role(String name, Optional<String> description, Optional<String> jsonDefaultAttributes, Optional<String> jsonOverrideAttributes, Optional<RunList> runlist) {
        this.name = Preconditions.checkNotNull(name, "name must be set");
        this.description = Preconditions.checkNotNull(description, "description must be set");
        this.jsonDefaultAttributes = Preconditions.checkNotNull(jsonDefaultAttributes, "jsonDefaultAttributes must be set");
        this.jsonOverrideAttributes = Preconditions.checkNotNull(jsonOverrideAttributes, "jsonOverrideAttributes must be set");
        this.runlist = Preconditions.checkNotNull(runlist, "runlist must be set").or(RunList.builder().build());
    }

    public String toJsonString() {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"name\": \"").append(this.name).append("\",");
        json.append("\"description\":\"").append(this.description.or("")).append("\",");
        json.append("\"default_attributes\":").append(this.jsonDefaultAttributes.or("{}")).append(",");
        json.append("\"override_attributes\":").append(this.jsonOverrideAttributes.or("{}")).append(",");
        json.append("\"json_class\":\"Chef::Role\",");
        json.append("\"chef_type\":\"role\",");
        json.append("\"run_list\":" + this.runlist.toString());
        json.append("}");
        return json.toString();
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Optional<String> getJsonDefaultAttributes() {
        return this.jsonDefaultAttributes;
    }

    public Optional<String> getJsonOverrideAttributes() {
        return this.jsonOverrideAttributes;
    }

    public RunList getRunlist() {
        return this.runlist;
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Role other = (Role)Role.class.cast(obj);
        return Objects.equal(this.name, other.name);
    }

    public String toString() {
        return Objects.toStringHelper(this).omitNullValues().add("name", this.name).add("description", this.description.orNull()).toString();
    }

    public static class Builder {
        private String name;
        private String description;
        private String jsonDefaultAttributes;
        private String jsonOverrideAttributes;
        private RunList runlist;

        public Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name must be set");
            return this;
        }

        public Builder description(String description) {
            this.description = Preconditions.checkNotNull(description, "description must be set");
            return this;
        }

        public Builder jsonDefaultAttributes(String jsonDefaultAttributes) {
            this.jsonDefaultAttributes = Preconditions.checkNotNull(jsonDefaultAttributes, "jsonDefaultAttributes must be set");
            return this;
        }

        public Builder jsonOverrideAttributes(String jsonOverrideAttributes) {
            this.jsonOverrideAttributes = Preconditions.checkNotNull(jsonOverrideAttributes, "jsonOverrideAttributes must be set");
            return this;
        }

        public Builder runlist(RunList runlist) {
            this.runlist = Preconditions.checkNotNull(runlist, "runlist must be set");
            return this;
        }

        public Role build() {
            return new Role(this.name, Optional.fromNullable(this.description), Optional.fromNullable(this.jsonDefaultAttributes), Optional.fromNullable(this.jsonOverrideAttributes), Optional.fromNullable(this.runlist));
        }
    }
}

