/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.jclouds.JcloudsBlobStoreEndpoint;
import org.apache.camel.component.jclouds.JcloudsBlobStoreHelper;
import org.apache.camel.component.jclouds.JcloudsProducer;
import org.apache.camel.util.ObjectHelper;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.io.Payload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsBlobStoreProducer
extends JcloudsProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsBlobStoreProducer.class);
    private final JcloudsBlobStoreEndpoint endpoint;
    private BlobStore blobStore;

    public JcloudsBlobStoreProducer(JcloudsBlobStoreEndpoint endpoint, BlobStore blobStore) {
        super(endpoint);
        this.blobStore = blobStore;
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        String container = this.endpoint.getContainer();
        String locationId = this.endpoint.getLocationId();
        JcloudsBlobStoreHelper.ensureContainerExists(this.blobStore, container, locationId);
    }

    public void process(Exchange exchange) throws Exception {
        String container = this.getContainerName(exchange);
        String blobName = this.getBlobName(exchange);
        String operation = this.getOperation(exchange);
        List blobNames = this.getBlobNameList(exchange);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing {} operation on '{}'", (Object)operation, (Object)(container + "/" + blobName));
        }
        if ("CamelJcloudsGet".equals(operation)) {
            exchange.getOut().setBody((Object)JcloudsBlobStoreHelper.readBlob(this.blobStore, container, blobName));
        } else if ("CamelJcloudsCountBlobs".equals(operation)) {
            exchange.getOut().setBody((Object)JcloudsBlobStoreHelper.countBlob(this.blobStore, container));
        } else if ("CamelJcloudsRemoveBlob".equals(operation)) {
            JcloudsBlobStoreHelper.removeBlob(this.blobStore, container, blobName);
        } else if ("CamelJcloudsClearContainer".equals(operation)) {
            JcloudsBlobStoreHelper.clearContainer(this.blobStore, container);
        } else if ("CamelJcloudsDeleteContainer".equals(operation)) {
            JcloudsBlobStoreHelper.deleteContainer(this.blobStore, container);
        } else if ("CamelJcloudsExistsContainer".equals(operation)) {
            exchange.getOut().setBody((Object)JcloudsBlobStoreHelper.containerExists(this.blobStore, container));
        } else if ("CamelJcloudsRemoveBlobs".equals(operation)) {
            JcloudsBlobStoreHelper.removeBlobs(this.blobStore, container, blobNames);
        } else {
            Payload body = (Payload)exchange.getIn().getBody(Payload.class);
            JcloudsBlobStoreHelper.writeBlob(this.blobStore, container, blobName, body);
        }
    }

    protected String getBlobName(Exchange exchange) {
        String blobName = ((JcloudsBlobStoreEndpoint)this.getEndpoint()).getBlobName();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelJcloudsBlobName"))) {
            blobName = (String)exchange.getIn().getHeader("CamelJcloudsBlobName", String.class);
        }
        return blobName;
    }

    protected String getContainerName(Exchange exchange) {
        String containerName = ((JcloudsBlobStoreEndpoint)this.getEndpoint()).getContainer();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelJcloudsContainerName"))) {
            containerName = (String)exchange.getIn().getHeader("CamelJcloudsContainerName", String.class);
        }
        return containerName;
    }

    public String getOperation(Exchange exchange) {
        String operation = ((JcloudsBlobStoreEndpoint)this.getEndpoint()).getOperation();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelJcloudsOperation"))) {
            operation = (String)exchange.getIn().getHeader("CamelJcloudsOperation", String.class);
        }
        return operation;
    }

    public String getLocationId(Exchange exchange) {
        String operation = ((JcloudsBlobStoreEndpoint)this.getEndpoint()).getLocationId();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelJcloudsLocationId"))) {
            operation = (String)exchange.getIn().getHeader("CamelJcloudsLocationId", String.class);
        }
        return operation;
    }

    public List getBlobNameList(Exchange exchange) {
        List blobNames = new ArrayList();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelJcloudsBlobNameList"))) {
            blobNames = (List)exchange.getIn().getHeader("CamelJcloudsBlobNameList", List.class);
        }
        return blobNames;
    }
}

