/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.base.Objects;
import com.google.common.hash.HashCode;
import java.util.Date;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataBuilder;

public class BaseImmutableContentMetadata
implements ContentMetadata {
    protected String cacheControl;
    protected String contentType;
    protected Long contentLength;
    protected HashCode contentMD5;
    protected String contentDisposition;
    protected String contentLanguage;
    protected String contentEncoding;
    protected Date expires;

    @Deprecated
    public BaseImmutableContentMetadata(String contentType, Long contentLength, byte[] contentMD5, String contentDisposition, String contentLanguage, String contentEncoding, Date expires) {
        this(null, contentType, contentLength, contentMD5, contentDisposition, contentLanguage, contentEncoding, expires);
    }

    public BaseImmutableContentMetadata(String cacheControl, String contentType, Long contentLength, byte[] contentMD5, String contentDisposition, String contentLanguage, String contentEncoding, Date expires) {
        this.cacheControl = cacheControl;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.contentMD5 = contentMD5 == null ? null : HashCode.fromBytes(contentMD5);
        this.contentDisposition = contentDisposition;
        this.contentLanguage = contentLanguage;
        this.contentEncoding = contentEncoding;
        this.expires = expires;
    }

    @Override
    public String getCacheControl() {
        return this.cacheControl;
    }

    @Override
    public Long getContentLength() {
        return this.contentLength;
    }

    @Override
    @Deprecated
    public byte[] getContentMD5() {
        HashCode hashCode = this.getContentMD5AsHashCode();
        return hashCode == null ? null : hashCode.asBytes();
    }

    @Override
    public HashCode getContentMD5AsHashCode() {
        return this.contentMD5;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentDisposition() {
        return this.contentDisposition;
    }

    @Override
    public String getContentLanguage() {
        return this.contentLanguage;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public Date getExpires() {
        return this.expires;
    }

    public String toString() {
        return "[cacheControl=" + this.cacheControl + "contentType=" + this.contentType + ", contentLength=" + this.contentLength + ", contentDisposition=" + this.contentDisposition + ", contentEncoding=" + this.contentEncoding + ", contentLanguage=" + this.contentLanguage + ", contentMD5=" + this.contentMD5 + ", expires = " + this.expires + "]";
    }

    public int hashCode() {
        return Objects.hashCode(this.contentDisposition, this.contentEncoding, this.contentLanguage, this.contentLength, this.contentMD5, this.contentType, this.expires);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseImmutableContentMetadata other = (BaseImmutableContentMetadata)obj;
        if (!Objects.equal(this.cacheControl, other.cacheControl)) {
            return false;
        }
        if (this.contentDisposition == null ? other.contentDisposition != null : !this.contentDisposition.equals(other.contentDisposition)) {
            return false;
        }
        if (this.contentEncoding == null ? other.contentEncoding != null : !this.contentEncoding.equals(other.contentEncoding)) {
            return false;
        }
        if (this.contentLanguage == null ? other.contentLanguage != null : !this.contentLanguage.equals(other.contentLanguage)) {
            return false;
        }
        if (this.contentLength == null ? other.contentLength != null : !this.contentLength.equals(other.contentLength)) {
            return false;
        }
        if (!Objects.equal(this.contentMD5, other.contentMD5)) {
            return false;
        }
        if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
            return false;
        }
        return Objects.equal(this.expires, other.expires);
    }

    @Override
    public ContentMetadataBuilder toBuilder() {
        return ContentMetadataBuilder.fromContentMetadata(this);
    }
}

