/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.logging.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.FileBackedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.logging.Logger;
import org.jclouds.util.Closeables2;

public abstract class Wire {
    @Resource
    protected Logger logger = Logger.NULL;

    protected abstract Logger getWireLog();

    protected boolean isLogSensitiveInformation() {
        return false;
    }

    private void wire(String header, InputStream instream) {
        StringBuilder buffer = new StringBuilder();
        try {
            int ch;
            while ((ch = instream.read()) != -1) {
                if (ch == 13) {
                    buffer.append("[\\r]");
                    continue;
                }
                if (ch == 10) {
                    buffer.append("[\\n]\"");
                    buffer.insert(0, "\"");
                    buffer.insert(0, header);
                    this.getWireLog().debug(buffer.toString(), new Object[0]);
                    buffer.setLength(0);
                    continue;
                }
                if (ch < 32 || ch > 127) {
                    buffer.append("[0x");
                    buffer.append(Integer.toHexString(ch));
                    buffer.append("]");
                    continue;
                }
                buffer.append((char)ch);
            }
            if (buffer.length() > 0) {
                buffer.append('\"');
                buffer.insert(0, '\"');
                buffer.insert(0, header);
                this.getWireLog().debug(buffer.toString(), new Object[0]);
            }
        }
        catch (IOException e) {
            this.logger.error(e, "Error tapping line", new Object[0]);
        }
    }

    public boolean enabled() {
        return this.getWireLog().isDebugEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream copy(String header, InputStream instream) {
        int limit = 262144;
        final FileBackedOutputStream out = new FileBackedOutputStream(limit);
        try {
            long bytesRead = ByteStreams.copy(instream, out);
            if (bytesRead >= (long)limit) {
                this.logger.debug("over limit %d/%d: wrote temp file", bytesRead, limit);
            }
            InputStream is = out.asByteSource().openStream();
            try {
                this.wire(header, is);
            }
            finally {
                is.close();
            }
            FilterInputStream filterInputStream = new FilterInputStream(out.asByteSource().openStream()){

                @Override
                public void close() throws IOException {
                    super.close();
                    out.reset();
                }
            };
            return filterInputStream;
        }
        catch (IOException e) {
            throw new RuntimeException("Error tapping line", e);
        }
        finally {
            Closeables2.closeQuietly(out);
            Closeables2.closeQuietly(instream);
        }
    }

    public InputStream input(InputStream instream) {
        return this.copy("<< ", Preconditions.checkNotNull(instream, "input"));
    }

    public void input(PayloadEnclosing request) {
        Payload oldContent = request.getPayload();
        Payload wiredPayload = !oldContent.isSensitive() || this.isLogSensitiveInformation() ? Payloads.newPayload(this.input(oldContent.getInput())) : Payloads.newPayload(oldContent.getInput());
        wiredPayload.setSensitive(oldContent.isSensitive());
        this.copyPayloadMetadata(oldContent, wiredPayload);
        request.setPayload(wiredPayload);
    }

    public void output(PayloadEnclosing request) {
        Payload wiredPayload;
        Payload oldContent = request.getPayload();
        if (!oldContent.isSensitive() || this.isLogSensitiveInformation()) {
            try {
                wiredPayload = Payloads.newPayload(this.output(oldContent.getRawContent()));
            }
            catch (UnsupportedOperationException e) {
                wiredPayload = Payloads.newPayload(this.output(oldContent.getInput()));
            }
        } else {
            try {
                wiredPayload = Payloads.newPayload(oldContent.getRawContent());
            }
            catch (UnsupportedOperationException e) {
                wiredPayload = Payloads.newPayload(oldContent.getInput());
            }
            this.output("Sensitive data in payload, use jclouds.wire.log.sensitive override to enable logging this data.");
        }
        wiredPayload.setSensitive(oldContent.isSensitive());
        this.copyPayloadMetadata(oldContent, wiredPayload);
        request.setPayload(wiredPayload);
    }

    private void copyPayloadMetadata(Payload oldContent, Payload wiredPayload) {
        MutableContentMetadata oldMd = oldContent.getContentMetadata();
        MutableContentMetadata wiredMd = wiredPayload.getContentMetadata();
        if (oldMd.getContentLength() != null) {
            wiredMd.setContentLength(oldMd.getContentLength());
        }
        wiredMd.setCacheControl(oldMd.getCacheControl());
        wiredMd.setContentType(oldMd.getContentType());
        wiredMd.setContentMD5(oldMd.getContentMD5());
        wiredMd.setContentDisposition(oldMd.getContentDisposition());
        wiredMd.setContentEncoding(oldMd.getContentEncoding());
        wiredMd.setContentLanguage(oldMd.getContentLanguage());
        wiredMd.setExpires(oldMd.getExpires());
    }

    public <T> T output(T data) {
        Preconditions.checkNotNull(data, "data");
        if (data instanceof InputStream) {
            return (T)this.copy(">> ", (InputStream)data);
        }
        if (data instanceof byte[]) {
            this.output((byte[])data);
            return data;
        }
        if (data instanceof String) {
            this.output((String)data);
            return data;
        }
        if (data instanceof File) {
            this.output((File)data);
            return data;
        }
        throw new UnsupportedOperationException("Content not supported " + data.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output(File out) {
        Preconditions.checkNotNull(out, "output");
        FileInputStream in = null;
        try {
            in = new FileInputStream(out);
            this.wire(">> ", in);
        }
        catch (FileNotFoundException e) {
            try {
                this.logger.error(e, "Error tapping file: %s", out);
            }
            catch (Throwable throwable) {
                Closeables2.closeQuietly(in);
                throw throwable;
            }
            Closeables2.closeQuietly(in);
        }
        Closeables2.closeQuietly(in);
    }

    private void output(byte[] b) {
        this.wire(">> ", new ByteArrayInputStream(Preconditions.checkNotNull(b, "output")));
    }

    private void output(String s) {
        this.output(Preconditions.checkNotNull(s, "output").getBytes());
    }
}

