/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.ssh;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class SshdConfig
implements Statement {
    private static final String sshdConfig = "/etc/ssh/sshd_config";
    private final Map<String, String> params;

    public SshdConfig(Map<String, String> params) {
        this.params = Preconditions.checkNotNull(params, "params");
    }

    @Override
    public String render(OsFamily family) {
        String linesToPrepend = Joiner.on('\n').withKeyValueSeparator(" ").join(this.params);
        Statement prependSshdConfig = Statements.exec(String.format("exec 3<> %1$s && awk -v TEXT=\"%2$s\n\" 'BEGIN {print TEXT}{print}' %1$s >&3", sshdConfig, linesToPrepend));
        Statement reloadSshdConfig = Statements.exec("hash service 2>&- && service ssh reload 2>&- || service sshd reload 2>&- || /etc/init.d/ssh* reload");
        return Statements.newStatementList(prependSshdConfig, reloadSshdConfig).render(family);
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }
}

