/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.component.jclouds.JcloudsBlobStoreEndpoint;
import org.apache.camel.component.jclouds.JcloudsBlobStoreHelper;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.options.ListContainerOptions;

public class JcloudsBlobStoreConsumer
extends ScheduledBatchPollingConsumer {
    private final JcloudsBlobStoreEndpoint endpoint;
    private final String container;
    private final BlobStore blobStore;
    private int maxMessagesPerPoll = 10;

    public JcloudsBlobStoreConsumer(JcloudsBlobStoreEndpoint endpoint, Processor processor, BlobStore blobStore) {
        super(endpoint, processor);
        this.blobStore = blobStore;
        this.endpoint = endpoint;
        this.container = endpoint.getContainer();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        String container = this.endpoint.getContainer();
        String locationId = this.endpoint.getLocationId();
        JcloudsBlobStoreHelper.ensureContainerExists(this.blobStore, container, locationId);
    }

    @Override
    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        LinkedList<Exchange> queue = new LinkedList<Exchange>();
        String directory = this.endpoint.getDirectory();
        ListContainerOptions opt = new ListContainerOptions();
        if (!Strings.isNullOrEmpty(directory)) {
            opt = opt.inDirectory(directory);
        }
        for (StorageMetadata storageMetadata : this.blobStore.list(this.container, opt.maxResults(this.maxMessagesPerPoll).recursive())) {
            InputStream body;
            String blobName = storageMetadata.getName();
            if (!storageMetadata.getType().equals((Object)StorageType.BLOB) || Strings.isNullOrEmpty(blobName) || (body = JcloudsBlobStoreHelper.readBlob(this.blobStore, this.container, blobName)) == null) continue;
            Exchange exchange = this.createExchange(true);
            CachedOutputStream cos = new CachedOutputStream(exchange);
            IOHelper.copy(body, cos);
            exchange.getIn().setBody(cos.newStreamCache());
            exchange.setProperty("CamelJcloudsBlobName", (Object)blobName);
            queue.add(exchange);
        }
        return queue.isEmpty() ? 0 : this.processBatch(CastUtils.cast(queue));
    }

    @Override
    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = ObjectHelper.cast(Exchange.class, exchanges.poll());
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            this.getProcessor().process(exchange);
            if (exchange.getException() != null) {
                throw exchange.getException();
            }
            this.blobStore.removeBlob(this.container, exchange.getProperty("CamelJcloudsBlobName", String.class));
        }
        return total;
    }
}

