/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.domain.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.domain.Location;
import org.jclouds.domain.internal.ResourceMetadataImpl;
import org.jclouds.javax.annotation.Nullable;

public class StorageMetadataImpl
extends ResourceMetadataImpl<StorageType>
implements StorageMetadata {
    @Nullable
    private final String eTag;
    @Nullable
    private final Date creationDate;
    @Nullable
    private final Date lastModified;
    private final StorageType type;
    @Nullable
    private final Long size;
    @Nullable
    private final Tier tier;

    public StorageMetadataImpl(StorageType type, @Nullable String id, @Nullable String name, @Nullable Location location, @Nullable URI uri, @Nullable String eTag, @Nullable Date creationDate, @Nullable Date lastModified, Map<String, String> userMetadata, @Nullable Long size, Tier tier) {
        super(id, name, location, uri, userMetadata);
        this.eTag = eTag;
        this.creationDate = creationDate;
        this.lastModified = lastModified;
        this.type = Preconditions.checkNotNull(type, "type");
        this.size = size;
        this.tier = tier;
    }

    @Deprecated
    public StorageMetadataImpl(StorageType type, @Nullable String id, @Nullable String name, @Nullable Location location, @Nullable URI uri, @Nullable String eTag, @Nullable Date creationDate, @Nullable Date lastModified, Map<String, String> userMetadata, @Nullable Long size) {
        this(type, id, name, location, uri, eTag, creationDate, lastModified, userMetadata, size, null);
    }

    @Deprecated
    public StorageMetadataImpl(StorageType type, @Nullable String id, @Nullable String name, @Nullable Location location, @Nullable URI uri, @Nullable String eTag, @Nullable Date creationDate, @Nullable Date lastModified, Map<String, String> userMetadata) {
        this(type, id, name, location, uri, eTag, creationDate, lastModified, userMetadata, null);
    }

    @Override
    public StorageType getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(new Object[]{super.hashCode(), this.eTag, this.creationDate, this.lastModified, this.type, this.size, this.tier});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageMetadataImpl other = (StorageMetadataImpl)obj;
        if (!Objects.equal(this.eTag, other.eTag)) {
            return false;
        }
        if (!Objects.equal(this.creationDate, other.creationDate)) {
            return false;
        }
        if (!Objects.equal(this.lastModified, other.lastModified)) {
            return false;
        }
        if (!Objects.equal((Object)this.type, (Object)other.type)) {
            return false;
        }
        if (!Objects.equal(this.size, other.size)) {
            return false;
        }
        return Objects.equal((Object)this.tier, (Object)other.tier);
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        return super.string().add("eTag", this.eTag).add("creationDate", this.creationDate).add("lastModified", this.lastModified).add("type", (Object)this.type).add("size", this.size).add("tier", (Object)this.tier);
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }
}

