/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cim.xml;

import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ResourceAllocationSettingDataHandler
extends ParseSax.HandlerWithResult<ResourceAllocationSettingData> {
    protected StringBuilder currentText = new StringBuilder();
    protected ResourceAllocationSettingData.Builder builder = ResourceAllocationSettingData.builder();

    @Override
    public ResourceAllocationSettingData getResult() {
        try {
            ResourceAllocationSettingData resourceAllocationSettingData = this.builder.build();
            return resourceAllocationSettingData;
        }
        finally {
            this.builder = ResourceAllocationSettingData.builder();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String current = SaxUtils.currentOrNull(this.currentText);
        if (current != null) {
            if (SaxUtils.equalsOrSuffix(qName, "ElementName")) {
                this.builder.elementName(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "InstanceID")) {
                this.builder.instanceID(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Caption")) {
                this.builder.caption(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Description")) {
                this.builder.description(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Address")) {
                this.builder.address(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "AddressOnParent")) {
                this.builder.addressOnParent(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "AllocationUnits")) {
                this.builder.allocationUnits(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "AutomaticAllocation")) {
                this.builder.automaticAllocation(Boolean.valueOf(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "AutomaticDeallocation")) {
                this.builder.automaticDeallocation(Boolean.valueOf(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "ConsumerVisibility")) {
                this.builder.consumerVisibility(ResourceAllocationSettingData.ConsumerVisibility.fromValue(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "Limit")) {
                this.builder.limit(Long.valueOf(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "MappingBehavior")) {
                this.builder.mappingBehavior(ResourceAllocationSettingData.MappingBehavior.fromValue(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "OtherResourceType")) {
                this.builder.otherResourceType(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Parent")) {
                this.builder.parent(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "PoolID")) {
                this.builder.poolID(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Reservation")) {
                this.builder.reservation(Long.valueOf(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "ResourceSubType")) {
                this.builder.resourceSubType(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "ResourceType")) {
                this.builder.resourceType(ResourceAllocationSettingData.ResourceType.fromValue(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "VirtualQuantity")) {
                this.builder.virtualQuantity(Long.valueOf(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "VirtualQuantityUnits")) {
                this.builder.virtualQuantityUnits(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Weight")) {
                this.builder.weight(Integer.valueOf(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "Connection")) {
                this.builder.connection(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "HostResource")) {
                this.builder.hostResource(current);
            }
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

