/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.cim.VirtualSystemSettingData;
import org.jclouds.ovf.Section;

public class VirtualHardwareSection
extends Section<VirtualHardwareSection> {
    protected final VirtualSystemSettingData virtualSystem;
    protected final Set<String> transports;
    protected final Set<ResourceAllocationSettingData> items;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return VirtualHardwareSection.builder().fromVirtualHardwareSection(this);
    }

    public VirtualHardwareSection(String info, Iterable<String> transports, VirtualSystemSettingData virtualSystem, Iterable<? extends ResourceAllocationSettingData> items) {
        super(info);
        this.virtualSystem = virtualSystem;
        this.transports = ImmutableSet.copyOf(Preconditions.checkNotNull(transports, "transports"));
        this.items = ImmutableSet.copyOf(Preconditions.checkNotNull(items, "items"));
    }

    public Set<String> getTransports() {
        return this.transports;
    }

    public VirtualSystemSettingData getSystem() {
        return this.virtualSystem;
    }

    public Set<? extends ResourceAllocationSettingData> getItems() {
        return this.items;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        result = 31 * result + (this.transports == null ? 0 : this.transports.hashCode());
        result = 31 * result + (this.virtualSystem == null ? 0 : this.virtualSystem.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualHardwareSection other = (VirtualHardwareSection)obj;
        if (this.items == null ? other.items != null : !this.items.equals(other.items)) {
            return false;
        }
        if (this.transports == null ? other.transports != null : !this.transports.equals(other.transports)) {
            return false;
        }
        return !(this.virtualSystem == null ? other.virtualSystem != null : !this.virtualSystem.equals(other.virtualSystem));
    }

    @Override
    public String toString() {
        return String.format("[info=%s, items=%s, transports=%s, virtualSystem=%s]", this.info, this.items, this.transports, this.virtualSystem);
    }

    public static class Builder
    extends Section.Builder<VirtualHardwareSection> {
        protected VirtualSystemSettingData virtualSystem;
        protected Set<String> transports = Sets.newLinkedHashSet();
        protected Set<ResourceAllocationSettingData> items = Sets.newLinkedHashSet();

        public Builder system(VirtualSystemSettingData virtualSystem) {
            this.virtualSystem = virtualSystem;
            return this;
        }

        public Builder transport(String transport) {
            this.transports.add(Preconditions.checkNotNull(transport, "transport"));
            return this;
        }

        public Builder transports(Iterable<String> transports) {
            this.transports = ImmutableSet.copyOf(Preconditions.checkNotNull(transports, "transports"));
            return this;
        }

        public Builder item(ResourceAllocationSettingData item) {
            this.items.add(Preconditions.checkNotNull(item, "item"));
            return this;
        }

        public Builder items(Iterable<? extends ResourceAllocationSettingData> items) {
            this.items = ImmutableSet.copyOf(Preconditions.checkNotNull(items, "items"));
            return this;
        }

        public VirtualHardwareSection build() {
            return new VirtualHardwareSection(this.info, this.transports, this.virtualSystem, this.items);
        }

        public Builder fromVirtualHardwareSection(VirtualHardwareSection in) {
            return ((Builder)this.fromSection((Section)in)).items(in.getItems()).transports(in.getTransports()).system(in.getSystem()).info(in.getInfo());
        }

        public Builder fromSection(Section<VirtualHardwareSection> in) {
            return (Builder)Builder.class.cast(super.fromSection(in));
        }

        public Builder info(String info) {
            return (Builder)Builder.class.cast(super.info(info));
        }
    }
}

