/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.TimeLimiter;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.Fallback;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.logging.Logger;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.config.InvocationConfig;

public class InvokeHttpMethod
implements Function<Invocation, Object> {
    @Resource
    private Logger logger = Logger.NULL;
    private final Function<Invocation, HttpRequest> annotationProcessor;
    private final HttpCommandExecutorService http;
    private final TimeLimiter timeLimiter;
    private final Function<HttpRequest, Function<HttpResponse, ?>> transformerForRequest;
    private final InvocationConfig config;

    @Inject
    @VisibleForTesting
    InvokeHttpMethod(Function<Invocation, HttpRequest> annotationProcessor, HttpCommandExecutorService http, Function<HttpRequest, Function<HttpResponse, ?>> transformerForRequest, TimeLimiter timeLimiter, InvocationConfig config) {
        this.annotationProcessor = annotationProcessor;
        this.http = http;
        this.timeLimiter = timeLimiter;
        this.transformerForRequest = transformerForRequest;
        this.config = config;
    }

    @Override
    public Object apply(Invocation in) {
        Optional<Long> timeoutNanos = this.config.getTimeoutNanos(in);
        if (timeoutNanos.isPresent()) {
            return this.invokeWithTimeout(in, timeoutNanos.get());
        }
        return this.invoke(in);
    }

    public Object invoke(Invocation invocation) {
        String commandName = this.config.getCommandName(invocation);
        HttpCommand command = this.toCommand(commandName, invocation);
        Function<HttpResponse, ?> transformer = this.getTransformer(commandName, command);
        Fallback<?> fallback = this.getFallback(commandName, invocation, command);
        this.logger.debug(">> invoking %s", commandName);
        try {
            return transformer.apply(this.http.invoke(command));
        }
        catch (Throwable t) {
            try {
                return fallback.createOrPropagate(t);
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }
    }

    public Object invokeWithTimeout(Invocation invocation, long limitNanos) {
        String commandName = this.config.getCommandName(invocation);
        HttpCommand command = this.toCommand(commandName, invocation);
        Fallback<?> fallback = this.getFallback(commandName, invocation, command);
        this.logger.debug(">> blocking on %s for %s", invocation, limitNanos);
        try {
            return this.timeLimiter.callWithTimeout(new InvokeAndTransform(commandName, command), limitNanos, TimeUnit.NANOSECONDS, true);
        }
        catch (Throwable t) {
            try {
                return fallback.createOrPropagate(t);
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }
    }

    private Fallback<?> getFallback(String commandName, Invocation invocation, HttpCommand command) {
        HttpRequest request = command.getCurrentRequest();
        Fallback<?> fallback = this.config.getFallback(invocation);
        if (fallback instanceof InvocationContext) {
            ((InvocationContext)InvocationContext.class.cast(fallback)).setContext(request);
        }
        this.logger.trace("<< exceptions from %s are parsed by %s", commandName, fallback.getClass().getSimpleName());
        return fallback;
    }

    private HttpCommand toCommand(String commandName, Invocation invocation) {
        this.logger.trace(">> converting %s", commandName);
        HttpRequest request = this.annotationProcessor.apply(invocation);
        this.logger.trace("<< converted %s to %s", commandName, request.getRequestLine());
        return new HttpCommand(request);
    }

    private Function<HttpResponse, ?> getTransformer(String commandName, HttpCommand command) {
        HttpRequest request = command.getCurrentRequest();
        Function<HttpResponse, ?> transformer = this.transformerForRequest.apply(request);
        this.logger.trace("<< response from %s is parsed by %s", commandName, transformer.getClass().getSimpleName());
        return transformer;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvokeHttpMethod that = (InvokeHttpMethod)InvokeHttpMethod.class.cast(o);
        return Objects.equal(this.annotationProcessor, that.annotationProcessor);
    }

    public int hashCode() {
        return Objects.hashCode(this.annotationProcessor);
    }

    public String toString() {
        return MoreObjects.toStringHelper("").omitNullValues().add("annotationParser", this.annotationProcessor).toString();
    }

    @VisibleForTesting
    final class InvokeAndTransform
    implements Callable<Object> {
        private final String commandName;
        private final HttpCommand command;
        private final Function<HttpResponse, ?> transformer;

        InvokeAndTransform(String commandName, HttpCommand command) {
            this.commandName = commandName;
            this.command = command;
            this.transformer = InvokeHttpMethod.this.getTransformer(commandName, command);
        }

        @Override
        public Object call() throws Exception {
            return this.transformer.apply(InvokeHttpMethod.this.http.invoke(this.command));
        }

        public int hashCode() {
            return Objects.hashCode(this.commandName, this.command, this.transformer);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            InvokeAndTransform that = (InvokeAndTransform)InvokeAndTransform.class.cast(obj);
            return Objects.equal(this.commandName, that.commandName) && Objects.equal(this.command, that.command) && Objects.equal(this.transformer, that.transformer);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("commandName", this.commandName).add("command", this.command).add("transformer", this.transformer).toString();
        }
    }
}

