/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jclouds;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.WrappedFile;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.xml.StreamSourceCache;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.io.payloads.InputStreamPayload;

@Converter(generateLoader=true)
public final class JcloudsPayloadConverter {
    private JcloudsPayloadConverter() {
    }

    @Converter
    public static Payload toPayload(byte[] bytes) {
        return new ByteSourcePayload(ByteSource.wrap(bytes));
    }

    @Converter
    public static Payload toPayload(String str, Exchange ex) throws UnsupportedEncodingException {
        return JcloudsPayloadConverter.toPayload(str.getBytes(ExchangeHelper.getCharsetName(ex)));
    }

    public static Payload toPayload(String str) throws UnsupportedEncodingException {
        return JcloudsPayloadConverter.toPayload(str, null);
    }

    @Converter
    public static Payload toPayload(File file) {
        return new ByteSourcePayload(Files.asByteSource(file));
    }

    protected static Payload setContentMetadata(Payload payload, Exchange exchange) {
        if (exchange == null) {
            return payload;
        }
        String contentType = exchange.getIn().getHeader("Content-Type", String.class);
        String contentEncoding = exchange.getIn().getHeader("Content-Encoding", String.class);
        String contentDisposition = exchange.getIn().getHeader("CamelJcloudsContentDisposition", String.class);
        String contentLanguage = exchange.getIn().getHeader("CamelJcloudsContentLanguage", String.class);
        Date payloadExpires = exchange.getIn().getHeader("CamelJcloudsPayloadExpires", Date.class);
        if (ObjectHelper.isNotEmpty(contentType)) {
            payload.getContentMetadata().setContentType(contentType);
        }
        if (ObjectHelper.isNotEmpty(contentEncoding)) {
            payload.getContentMetadata().setContentEncoding(contentEncoding);
        }
        if (ObjectHelper.isNotEmpty(contentDisposition)) {
            payload.getContentMetadata().setContentDisposition(contentDisposition);
        }
        if (ObjectHelper.isNotEmpty(contentLanguage)) {
            payload.getContentMetadata().setContentLanguage(contentLanguage);
        }
        if (ObjectHelper.isNotEmpty(payloadExpires)) {
            payload.getContentMetadata().setExpires(payloadExpires);
        }
        return payload;
    }

    @Converter
    public static Payload toPayload(InputStream is, Exchange exchange) throws IOException {
        InputStreamPayload payload = new InputStreamPayload(is);
        if (is.markSupported()) {
            long contentLength = ByteStreams.toByteArray(is).length;
            is.reset();
            payload.getContentMetadata().setContentLength(contentLength);
        }
        return payload;
    }

    @Converter
    public static Payload toPayload(StreamSource source, Exchange exchange) throws IOException {
        return JcloudsPayloadConverter.toPayload(new StreamSourceCache(source, exchange), exchange);
    }

    @Converter
    public static Payload toPayload(StreamSourceCache cache, Exchange exchange) throws IOException {
        long contentLength = ByteStreams.toByteArray(cache.getInputStream()).length;
        cache.reset();
        InputStreamPayload payload = new InputStreamPayload(cache.getInputStream());
        payload.getContentMetadata().setContentLength(contentLength);
        JcloudsPayloadConverter.setContentMetadata(payload, exchange);
        return payload;
    }

    @Converter(fallback=true)
    public static <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        TypeConverter converter;
        WrappedFile wf;
        Class<?> sourceType = value.getClass();
        if (type == Payload.class && WrappedFile.class.isAssignableFrom(sourceType) && (wf = (WrappedFile)value).getFile() != null && (converter = registry.lookup(Payload.class, wf.getFile().getClass())) != null) {
            return (T)converter.tryConvertTo(Payload.class, wf.getFile());
        }
        return null;
    }
}

