/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.ValueDefinition;
import org.apache.camel.model.rest.CollectionFormat;
import org.apache.camel.model.rest.ResponseMessageDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.DslProperty;
import org.apache.camel.util.StringHelper;

@Metadata(label="rest")
@XmlRootElement(name="responseHeader")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResponseHeaderDefinition {
    @XmlTransient
    private ResponseMessageDefinition response;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute
    private String description;
    @XmlAttribute
    @Metadata(defaultValue="csv")
    private CollectionFormat collectionFormat = CollectionFormat.csv;
    @XmlAttribute
    @Metadata(defaultValue="string")
    private String arrayType = "string";
    @XmlAttribute
    @Metadata(defaultValue="string")
    private String dataType = "string";
    @XmlAttribute
    private String dataFormat;
    @XmlElementWrapper(name="allowableValues")
    @XmlElement(name="value")
    @DslProperty(name="allowableValues")
    private List<ValueDefinition> allowableValues;
    @XmlAttribute
    private String example;

    public ResponseHeaderDefinition(ResponseMessageDefinition response) {
        this();
        this.response = response;
    }

    public ResponseHeaderDefinition() {
    }

    public ResponseMessageDefinition endResponseHeader() {
        return this.response;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    public void setCollectionFormat(CollectionFormat collectionFormat) {
        this.collectionFormat = collectionFormat;
    }

    public String getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(String arrayType) {
        this.arrayType = arrayType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public List<ValueDefinition> getAllowableValues() {
        return this.allowableValues;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public void setAllowableValues(List<ValueDefinition> allowableValues) {
        this.allowableValues = allowableValues;
    }

    public ResponseHeaderDefinition name(String name) {
        this.setName(name);
        return this;
    }

    public ResponseHeaderDefinition description(String name) {
        this.setDescription(name);
        return this;
    }

    public ResponseHeaderDefinition collectionFormat(CollectionFormat collectionFormat) {
        this.setCollectionFormat(collectionFormat);
        return this;
    }

    public ResponseHeaderDefinition arrayType(String arrayType) {
        this.setArrayType(arrayType);
        return this;
    }

    public ResponseHeaderDefinition dataType(String type) {
        this.setDataType(type);
        return this;
    }

    public ResponseHeaderDefinition dataFormat(String type) {
        this.setDataFormat(type);
        return this;
    }

    public ResponseHeaderDefinition allowableValues(List<String> allowableValues) {
        ArrayList<ValueDefinition> list = new ArrayList<ValueDefinition>();
        for (String av : allowableValues) {
            list.add(new ValueDefinition(av));
        }
        this.setAllowableValues(list);
        return this;
    }

    public ResponseHeaderDefinition allowableValues(String ... allowableValues) {
        ArrayList<ValueDefinition> list = new ArrayList<ValueDefinition>();
        for (String av : allowableValues) {
            list.add(new ValueDefinition(av));
        }
        this.setAllowableValues(list);
        return this;
    }

    public ResponseHeaderDefinition allowableValues(String allowableValues) {
        ArrayList<ValueDefinition> list = new ArrayList<ValueDefinition>();
        for (String av : allowableValues.split(",")) {
            list.add(new ValueDefinition(av));
        }
        this.setAllowableValues(list);
        return this;
    }

    public ResponseHeaderDefinition example(String example) {
        this.setExample(example);
        return this;
    }

    public ResponseMessageDefinition endHeader() {
        StringHelper.notEmpty(this.name, "name");
        StringHelper.notEmpty(this.dataType, "dataType");
        return this.response;
    }

    public List<String> getAllowableValuesAsStringList() {
        if (this.allowableValues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> answer = new ArrayList<String>();
        for (ValueDefinition v : this.allowableValues) {
            answer.add(v.getValue());
        }
        return answer;
    }
}

