/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.Traceable;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware,
RouteIdAware,
ShutdownAware {
    private static final Logger LOG = LoggerFactory.getLogger(LoopProcessor.class);
    private String id;
    private String routeId;
    private boolean shutdownPending;
    private final CamelContext camelContext;
    private final ReactiveExecutor reactiveExecutor;
    private final Expression expression;
    private final Predicate predicate;
    private final boolean copy;
    private final boolean breakOnShutdown;
    private final LongAdder taskCount = new LongAdder();

    public LoopProcessor(CamelContext camelContext, Processor processor, Expression expression, Predicate predicate, boolean copy, boolean breakOnShutdown) {
        super(processor);
        this.camelContext = camelContext;
        this.reactiveExecutor = camelContext.adapt(ExtendedCamelContext.class).getReactiveExecutor();
        this.expression = expression;
        this.predicate = predicate;
        this.copy = copy;
        this.breakOnShutdown = breakOnShutdown;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            LoopState state = new LoopState(exchange, callback);
            if (exchange.isTransacted()) {
                this.reactiveExecutor.scheduleQueue(state);
            } else {
                this.reactiveExecutor.scheduleMain(state);
            }
            return false;
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    @Override
    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return !this.breakOnShutdown;
    }

    @Override
    public int getPendingExchangesSize() {
        return this.taskCount.intValue();
    }

    @Override
    public void prepareShutdown(boolean suspendOnly, boolean forced) {
        this.shutdownPending = true;
    }

    protected Exchange prepareExchange(Exchange exchange, int index) {
        if (this.copy) {
            return ExchangeHelper.createCopy(exchange, true);
        }
        ExchangeHelper.prepareOutToIn(exchange);
        return exchange;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public boolean isCopy() {
        return this.copy;
    }

    @Override
    public String getTraceLabel() {
        if (this.predicate != null) {
            return "loopWhile[" + this.predicate + "]";
        }
        return "loop[" + this.expression + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public String toString() {
        return this.id;
    }

    class LoopState
    implements Runnable {
        final Exchange exchange;
        final AsyncCallback callback;
        Exchange current;
        int index;
        int count;

        public LoopState(Exchange exchange, AsyncCallback callback) throws NoTypeConversionAvailableException {
            this.exchange = exchange;
            this.callback = callback;
            this.current = exchange;
            if (LoopProcessor.this.expression != null) {
                String text = LoopProcessor.this.expression.evaluate(exchange, String.class);
                this.count = ExchangeHelper.convertToMandatoryType(exchange, Integer.class, text);
                LoopProcessor.this.taskCount.add(this.count);
                exchange.setProperty(ExchangePropertyKey.LOOP_SIZE, (Object)this.count);
            }
        }

        @Override
        public void run() {
            try {
                boolean isStopping;
                boolean cont = PipelineHelper.continueProcessing(this.current, "so breaking out of loop", LOG);
                boolean doWhile = LoopProcessor.this.predicate == null || LoopProcessor.this.predicate.matches(this.current);
                boolean doLoop = LoopProcessor.this.expression == null || this.index < this.count;
                boolean bl = isStopping = LoopProcessor.this.shutdownPending && LoopProcessor.this.breakOnShutdown;
                if (cont && doWhile && doLoop && !isStopping) {
                    this.current = LoopProcessor.this.prepareExchange(this.exchange, this.index);
                    LOG.debug("LoopProcessor: iteration #{}", (Object)this.index);
                    this.current.setProperty(ExchangePropertyKey.LOOP_INDEX, (Object)this.index);
                    LoopProcessor.this.processor.process(this.current, doneSync -> {
                        ++this.index;
                        if (LoopProcessor.this.expression != null) {
                            LoopProcessor.this.taskCount.decrement();
                        }
                        LoopProcessor.this.reactiveExecutor.schedule(this);
                    });
                } else {
                    ExchangeHelper.copyResults(this.exchange, this.current);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)this.exchange);
                    }
                    this.callback.done(false);
                }
            }
            catch (Exception e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing failed for exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)e.getMessage());
                }
                this.exchange.setException(e);
                this.callback.done(false);
            }
        }

        public String toString() {
            return "LoopState";
        }
    }
}

